/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.graph;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphObservable<V> {
    private final List<Consumer<Throwable>> myListeners;
    private final MultiMap<GraphObserver, GraphObserver> myMap;
    private final GraphObserver<V, ?> myRoot;
    private final V myInitializer;

    private GraphObservable(@NotNull MultiMap<GraphObserver, GraphObserver> map, @NotNull GraphObserver<V, ?> root2, @Nullable V initializer) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/database/dbimport/graph/GraphObservable", "<init>"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dbimport/graph/GraphObservable", "<init>"));
        }
        this.myMap = map;
        this.myRoot = root2;
        this.myInitializer = initializer;
        this.myListeners = ContainerUtil.newArrayList();
        ObserverListener listener = new ObserverListener(this);
        for (GraphObserver observer : map.keySet()) {
            observer.addListener(listener);
        }
    }

    @NotNull
    public CompletionStage<?> init() {
        CompletionStage completionStage = this.myRoot.notifyChanged(this.myInitializer).thenCompose(o -> GraphObservable.notifyObservers(this.myRoot, this, ContainerUtil.newHashSet(), o).whenComplete((o1, e1) -> this.changed((Throwable)e1)));
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/graph/GraphObservable", "init"));
        }
        return completionStage;
    }

    public void addListener(@NotNull Consumer<Throwable> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/graph/GraphObservable", "addListener"));
        }
        this.myListeners.add(consumer);
    }

    private void changed(@Nullable Throwable throwable) {
        this.myListeners.forEach(listener -> listener.consume((Object)AsyncUtil.unwrap(throwable)));
    }

    @NotNull
    private Collection<GraphObserver> next(@NotNull GraphObserver<?, ?> first) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/database/dbimport/graph/GraphObservable", "next"));
        }
        Collection collection = this.myMap.get(first);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/graph/GraphObservable", "next"));
        }
        return collection;
    }

    @NotNull
    private static <V> CompletionStage<?> notifyObservers(@NotNull GraphObserver<?, ?> observer, @NotNull GraphObservable<V> observable, @NotNull Set<GraphObserver<?, ?>> set, @Nullable Object o) {
        if (observer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/database/dbimport/graph/GraphObservable", "notifyObservers"));
        }
        if (observable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observable", "com/intellij/database/dbimport/graph/GraphObservable", "notifyObservers"));
        }
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/database/dbimport/graph/GraphObservable", "notifyObservers"));
        }
        if (set.contains(observer)) {
            throw new IllegalStateException();
        }
        set.add(observer);
        Collection<GraphObserver> next = super.next(observer);
        if (next.isEmpty()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/graph/GraphObservable", "notifyObservers"));
            }
            return completableFuture;
        }
        CompletableFuture[] futures = (CompletableFuture[])next.stream().map(graphObserver -> {
            if (observable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observable", "com/intellij/database/dbimport/graph/GraphObservable", "lambda$notifyObservers$4"));
            }
            if (set == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/database/dbimport/graph/GraphObservable", "lambda$notifyObservers$4"));
            }
            return graphObserver.notifyChanged(o).thenCompose(obj -> {
                if (observable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observable", "com/intellij/database/dbimport/graph/GraphObservable", "lambda$null$3"));
                }
                if (set == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/database/dbimport/graph/GraphObservable", "lambda$null$3"));
                }
                return GraphObservable.notifyObservers(graphObserver, observable, set, obj);
            });
        }).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures);
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/graph/GraphObservable", "notifyObservers"));
        }
        return completableFuture;
    }

    public static class Builder<V> {
        private final List<GraphObserver<?, ?>> myObservers = ContainerUtil.newArrayList();
        private GraphObserver<V, ?> myRoot;
        private V myInitializer;

        @NotNull
        public Builder<V> add(@NotNull List<? extends GraphObserver<?, ?>> observers) {
            if (observers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observers", "com/intellij/database/dbimport/graph/GraphObservable$Builder", "add"));
            }
            for (GraphObserver<?, ?> observer : observers) {
                this.add(observer);
            }
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/graph/GraphObservable$Builder", "add"));
            }
            return builder;
        }

        @NotNull
        public Builder<V> add(@NotNull GraphObserver<?, ?> observer) {
            if (observer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/database/dbimport/graph/GraphObservable$Builder", "add"));
            }
            this.myObservers.add(observer);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/graph/GraphObservable$Builder", "add"));
            }
            return builder;
        }

        @NotNull
        public Builder<V> root(@NotNull GraphObserver<V, ?> root2) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dbimport/graph/GraphObservable$Builder", "root"));
            }
            this.myRoot = root2;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/graph/GraphObservable$Builder", "root"));
            }
            return builder;
        }

        @NotNull
        public Builder<V> initializer(@Nullable V initializer) {
            this.myInitializer = initializer;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/graph/GraphObservable$Builder", "initializer"));
            }
            return builder;
        }

        @NotNull
        public GraphObservable<V> build() {
            MultiMap map = new MultiMap();
            for (GraphObserver<?, ?> observer : this.myObservers) {
                List<GraphObserver<?, ?>> next = this.next(observer);
                for (GraphObserver<?, ?> nextObserver : next) {
                    map.putValue(observer, nextObserver);
                }
            }
            GraphObservable graphObservable = new GraphObservable(map, this.myRoot, this.myInitializer);
            if (graphObservable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/graph/GraphObservable$Builder", "build"));
            }
            return graphObservable;
        }

        @NotNull
        private List<GraphObserver<?, ?>> next(@NotNull GraphObserver<?, ?> observer) {
            if (observer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/database/dbimport/graph/GraphObservable$Builder", "next"));
            }
            ArrayList list = ContainerUtil.newArrayList();
            for (GraphObserver<?, ?> current : this.myObservers) {
                if (observer == current || !observer.dependsOn(current)) continue;
                list.add(current);
            }
            ArrayList arrayList = list;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/graph/GraphObservable$Builder", "next"));
            }
            return arrayList;
        }
    }

    public static class ObserverListener<V>
    implements EventListener {
        private final GraphObservable<V> myObservable;

        public ObserverListener(@NotNull GraphObservable<V> observable) {
            if (observable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observable", "com/intellij/database/dbimport/graph/GraphObservable$ObserverListener", "<init>"));
            }
            this.myObservable = observable;
        }

        public void changed(GraphObserver<?, ?> observer, Object object) {
            GraphObservable.notifyObservers(observer, (GraphObservable)this.myObservable, ContainerUtil.newHashSet(), object).whenComplete((o, e) -> ((GraphObservable)this.myObservable).changed(e));
        }
    }

    public static interface GraphObserver<IN, OUT> {
        public void addListener(@NotNull ObserverListener<?> var1);

        @NotNull
        public CompletionStage<OUT> notifyChanged(@Nullable IN var1);

        public boolean dependsOn(@NotNull GraphObserver<?, ?> var1);
    }
}

