/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vendors.postgres.PostgresDialectHelper;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Version;

public class RedshiftDialect
extends AbstractDatabaseDialect
implements DatabaseDialect,
AbstractDatabaseDialect.SplitAlterColumnSupport {
    private static final int FRACTIONAL_SECONDS_PRECISION_MAX = 6;
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.DATABASE).put(ObjectKind.DATABASE, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.SCHEMA, ObjectKind.OPERATOR).put(ObjectKind.SCHEMA, ObjectKind.OBJECT_TYPE).put(ObjectKind.OBJECT_TYPE, ObjectKind.OBJECT_ATTRIBUTE).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).put(ObjectKind.OPERATOR, ObjectKind.ARGUMENT).build();
    public static final RedshiftDialect INSTANCE = new RedshiftDialect();

    protected RedshiftDialect() {
        super(META_MODEL, new TypeHelper.PostgresTypeHelper(), new KeywordHelper.PostgresKeywords(), BasicNamespace.LOWER_CASING);
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.REDSHIFT;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Redshift;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Redshift" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "getDisplayName"));
        }
        return "Redshift";
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return true;
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @Override
    protected boolean isNameFriendlyCharacter(char ch) {
        return ch == '_' || ch == '$';
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new DasDdlOperations.DefaultDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "getDdlOperations"));
        }
        return ddlOperations;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryData", "com/intellij/database/dialects/RedshiftDialect", "getBinaryLiteralString"));
        }
        return "E'\\\\x" + DialectUtils.toHexString(binaryData) + "'";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseProductVersion", "com/intellij/database/dialects/RedshiftDialect", "supportsProduct"));
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase(Locale.ENGLISH).startsWith("postgresql");
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDropColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/RedshiftDialect", "sqlDropColumn"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlDropColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column, boolean singlePk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDefineColumn"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefinitionSQL(builder, column, singlePk);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlDefineColumn"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropRule() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDropTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/RedshiftDialect", "sqlDropTable"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dialects/RedshiftDialect", "sqlDropTable"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlDropTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/dialects/RedshiftDialect", "getTypeName"));
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "getTypeName"));
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        if (jdbcType == -7 && "bool".equals(typeName)) {
            if ("bool" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "getTypeName"));
            }
            return "bool";
        }
        if (jdbcType == -5 && "oid".equals(typeName)) {
            if ("oid" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "getTypeName"));
            }
            return "oid";
        }
        if (jdbcType == 93 || jdbcType == 92) {
            int fractionalSecondsPrecision = dataType.getScale();
            String string = JdbcUtil.getJdbcTypeName((DataType)dataType, (boolean)false) + (fractionalSecondsPrecision != 6 ? "(" + fractionalSecondsPrecision + ")" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "getTypeName"));
            }
            return string;
        }
        if (jdbcType == 2) {
            String string = "numeric" + (dataType.getLength() == 131089 ? "" : "(" + dataType.getPrecision() + (dataType.getScale() == 0 ? "" : ", " + dataType.getScale()) + ")");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "getTypeName"));
            }
            return string;
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "getTypeName"));
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlAddPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/RedshiftDialect", "sqlAddPrimaryKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlAddPrimaryKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnComment"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnComment"));
        }
        builder.suppressQuoteConstraints(true);
        DdlBuilder ddlBuilder = DialectUtils.getColumnCommentAlterSQL(builder, column, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this)).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnComment"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnNullable"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnNullable"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable());
        builder.space().keywords("ALTER", "COLUMN").space();
        builder.columnRef((DasObject)column).space();
        builder.keyword(!column.isNotNull() ? "DROP" : "SET").space().keyword("NOT").space().keyword("NULL");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnNullable"));
        }
        return ddlBuilder;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnName"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnName"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnName"));
        }
        String alterClause = "RENAME COLUMN";
        String toClause = "TO";
        DdlBuilder ddlBuilder = DialectUtils.getColumnNameAlterSQL(builder, from, toName, alterClause, toClause);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnName"));
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnType"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnType"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnType"));
        }
        throw new UnsupportedOperationException("Alter column type is not supported by Redshift");
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnDefault"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnDefault"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefaultAlterOrDropSQL(builder, column);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterColumnDefault"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDropPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/RedshiftDialect", "sqlDropPrimaryKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropPrimaryKeySQL(builder, pk, true, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlDropPrimaryKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDropProcedure"));
        }
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "com/intellij/database/dialects/RedshiftDialect", "sqlDropProcedure"));
        }
        String type = procedure.getRoutineKind().name();
        builder.keyword("DROP").space().keyword(type);
        builder.space();
        builder.qualifiedRef((DasObject)procedure).symbol("(");
        boolean first = true;
        for (DasArgument arg : DasUtil.getParameters((DasRoutine)procedure)) {
            DasArgument.Direction direction = arg.getArgumentDirection();
            if (direction != DasArgument.Direction.IN && direction != DasArgument.Direction.INOUT) continue;
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.type((DasTypedObject)arg);
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlDropProcedure"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTrigger(@NotNull DdlBuilder builder, @NotNull DasTrigger trigger2) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDropTrigger"));
        }
        if (trigger2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trigger", "com/intellij/database/dialects/RedshiftDialect", "sqlDropTrigger"));
        }
        throw new UnsupportedOperationException("Drop trigger is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropRule(@NotNull DdlBuilder builder, @NotNull DasTableChild rule) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDropRule"));
        }
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/database/dialects/RedshiftDialect", "sqlDropRule"));
        }
        throw new UnsupportedOperationException("Drop rule is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropOperator(@NotNull DdlBuilder builder, @NotNull DasOperator operator) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDropOperator"));
        }
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "com/intellij/database/dialects/RedshiftDialect", "sqlDropOperator"));
        }
        throw new UnsupportedOperationException("Drop operator is not supported by Redshift");
    }

    @Override
    public boolean supportsCreateDatabase() {
        return true;
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsIndexes() {
        return false;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsAccessMethods() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsRenameView() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return false;
    }

    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsDropMaterializedView() {
        return false;
    }

    @Override
    public boolean supportsDropOperator() {
        return false;
    }

    @Override
    public boolean supportsDropType() {
        return true;
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return false;
    }

    public boolean supportsDropSequence() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return false;
    }

    public String[] getIndexAccessMethodsTypes() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlRenameTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/RedshiftDialect", "sqlRenameTable"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/RedshiftDialect", "sqlRenameTable"));
        }
        builder.keyword("ALTER TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keywords("RENAME", "TO").space();
        builder.newName(newName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlRenameTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateView"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateView"));
        }
        if (checkOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkOption", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateView"));
        }
        builder.keywords("CREATE", "OR", "REPLACE", "VIEW").space().qualifiedRef((DasObject)view2).space().keyword("AS").space().plain(definition);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlRenameView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/RedshiftDialect", "sqlRenameView"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/RedshiftDialect", "sqlRenameView"));
        }
        DdlBuilder ddlBuilder = this.sqlRenameTable(builder, view2, newName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlRenameView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view2, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDropView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/RedshiftDialect", "sqlDropView"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view2, cascade);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlDropView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateIndex"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateIndex"));
        }
        if (accessMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessMethod", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateIndex"));
        }
        if (tablespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tablespace", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateIndex"));
        }
        if (constraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateIndex"));
        }
        throw new UnsupportedOperationException("Create index is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDropIndex"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/RedshiftDialect", "sqlDropIndex"));
        }
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/database/dialects/RedshiftDialect", "sqlDropIndex"));
        }
        throw new UnsupportedOperationException("Drop index is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateSequence"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/RedshiftDialect", "sqlCreateSequence"));
        }
        throw new UnsupportedOperationException("Create sequence is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterSequence"));
        }
        if (restart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restart", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/RedshiftDialect", "sqlAlterSequence"));
        }
        throw new UnsupportedOperationException("Alter sequence is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlSequenceInformation"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/RedshiftDialect", "sqlSequenceInformation"));
        }
        throw new UnsupportedOperationException("Sequence information is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDropSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/RedshiftDialect", "sqlDropSequence"));
        }
        throw new UnsupportedOperationException("Drop sequence is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlAddForeignKey"));
        }
        if (keyInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyInfo", "com/intellij/database/dialects/RedshiftDialect", "sqlAddForeignKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, matchFull, autoFKIndex, this);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlAddForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlAddUniqueConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/RedshiftDialect", "sqlAddUniqueConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/RedshiftDialect", "sqlAddUniqueConstraint"));
        }
        if (columns2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dialects/RedshiftDialect", "sqlAddUniqueConstraint"));
        }
        DialectUtils.getAddUniqueConstraintSQL(builder, table, constraint, constraintName, columns2);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlAddUniqueConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlAddColumnAutoIncrement"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/RedshiftDialect", "sqlAddColumnAutoIncrement"));
        }
        throw new UnsupportedOperationException("Add autoincrement is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDropConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/RedshiftDialect", "sqlDropConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/RedshiftDialect", "sqlDropConstraint"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlDropConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadTableDefinition"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadTableDefinition"));
        }
        String string = PostgresDialectHelper.getTableDefinition(table, connection);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadTableDefinition"));
        }
        return string;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadTableInfo"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadTableInfo"));
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, String.format("SELECT CAST(reltuples as INT) as rows FROM pg_catalog.pg_class C\n  LEFT JOIN pg_catalog.pg_namespace N ON (N.oid = C.relnamespace)\nWHERE (relkind = 'r' OR relkind = 'v') AND nspname LIKE '%s' ESCAPE '#' AND relname LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql(DasUtil.getSchema((DasObject)element), true, this), DbImplUtil.escapeSql(element.getName(), true, this)), new String[0]);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadTableInfo"));
        }
        return map;
    }

    @Override
    public boolean supportsSearchPath() {
        return true;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull DatabaseConnection connection) throws SQLException {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadSearchPath"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadSearchPath"));
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, "select current_database() as a, current_schemas(false) as b", new String[0]);
        String db = String.valueOf(map.get("a"));
        Object[] schemas = (Object[])ObjectUtils.tryCast((Object)map.get("b"), Object[].class);
        return StringUtil.isEmpty((String)db) || schemas == null || schemas.length == 0 ? null : SearchPath.of(JBIterable.of((Object[])schemas).filter(String.class).transform(s -> new ObjectPath(ObjectKind.SCHEMA, Arrays.asList(db, s))).toList());
    }

    @Override
    public String sqlSetSearchPath(@NotNull DatabaseSystem system, @NotNull SearchPath path) {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dialects/RedshiftDialect", "sqlSetSearchPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dialects/RedshiftDialect", "sqlSetSearchPath"));
        }
        if (path.getCurrent().kind != ObjectKind.SCHEMA) {
            return null;
        }
        DdlBuilder builder = new DdlBuilder().plain("set search_path = ").quoteIdentifiers(true);
        boolean first = true;
        for (ObjectPath e : path.elements) {
            if (!first) {
                builder.plain(", ");
            }
            first = false;
            builder.identifier(e.getName());
        }
        return builder.getStatement();
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlAddColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/RedshiftDialect", "sqlAddColumn"));
        }
        if (attrs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrs", "com/intellij/database/dialects/RedshiftDialect", "sqlAddColumn"));
        }
        DialectUtils.getAddColumnSQL(builder, column, true, true, true, DasUtil.isAutoVal((DasColumn)column) ? "serial" : null);
        builder.newStatement();
        if (StringUtil.isNotEmpty((String)column.getComment())) {
            this.sqlAlterColumnComment(builder, column);
            builder.newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlAddColumn"));
        }
        return ddlBuilder;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/RedshiftDialect", "sqlViewDefinition"));
        }
        return Pair.create((Object)("select view_definition from information_schema.views where table_schema = '" + DasUtil.getSchema((DasObject)element) + "' and table_name = '" + element.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/RedshiftDialect", "sqlProcedureDefinition"));
        }
        Pair pair = Pair.create((Object)("select routine_definition from information_schema.routines where routine_schema = '" + DasUtil.getSchema((DasObject)element) + "' and routine_name = '" + element.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlProcedureDefinition"));
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull DatabaseConnection connection) throws Exception {
        Version curVersion;
        DdlBuilder builder;
        block15: {
            String string;
            if (proc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proc", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadProcedureDefinition"));
            }
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadProcedureDefinition"));
            }
            DatabaseMetaData md = connection.getMetaData();
            builder = new DdlBuilder().withDialect(this).qualifyReferences(true);
            curVersion = Version.of((int[])new int[]{md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion()});
            try {
                if (!curVersion.isOrGreater(new int[]{8, 4})) break block15;
                string = DbImplUtil.concatStringResults(connection, this, "SELECT pg_get_functiondef(p.oid) FROM pg_proc p JOIN pg_namespace n ON n.oid=pronamespace WHERE proname = " + PostgresDialectHelper.str(proc.getName()) + " AND nspname = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)proc)), 0, DbImplUtil.ConcatenationProps.LINES);
            }
            catch (Exception e) {
                Logger.getInstance(this.getClass()).info((Throwable)e);
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadProcedureDefinition"));
            }
            return string;
        }
        boolean isPre81 = Version.of((int[])new int[]{8, 0}).isOrGreater(curVersion);
        int limit = Math.max(10, Iterables.size((Iterable)proc.getArguments())) + 5;
        String s = "SELECT proname, proisagg, prosecdef, proisstrict, proretset, provolatile, pronargs, prosrc, probin,\n       lanname, \n" + PostgresDialectHelper.typeArg("tr", "rettype", "prorettype", isPre81) + ",\n" + PostgresDialectHelper.select(limit, isPre81) + "\n       " + (isPre81 ? "null dummy" : "proargmodes, pg_catalog.pg_get_expr(proargdefaults, 0) as proargdefaults") + "\n  FROM pg_proc\n  JOIN pg_namespace nsp ON nsp.oid=pronamespace\n  JOIN pg_language l ON l.oid=prolang\n" + PostgresDialectHelper.joinType("tr", "prorettype", isPre81) + "\n" + PostgresDialectHelper.join(limit, isPre81) + "  WHERE proname = " + PostgresDialectHelper.str(proc.getName()) + " AND nsp.nspname = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)proc)) + "\n";
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery(s);
        while (rs.next()) {
            builder.keywords("CREATE", "OR", "REPLACE", "FUNCTION").space().qualifiedRef((DasObject)proc).symbol("(");
            PostgresDialectHelper.SignatureBuilder signatureBuilder = new PostgresDialectHelper.SignatureBuilder(isPre81, rs);
            signatureBuilder.buildArguments(builder);
            builder.symbol(")").newLine().space(2).keyword("RETURNS").space();
            signatureBuilder.buildReturn(builder);
            String language = rs.getString("lanname");
            String src = ((String)ObjectUtils.notNull((Object)rs.getString("prosrc"), (Object)"")).trim();
            if ("c".equals(language)) {
                builder.newLine().keyword("AS").newLine().symbol("'").plain(rs.getString("probin")).symbol("'").symbol(",").space().symbol("'").plain(src).symbol("'");
            } else {
                builder.newLine().keyword("AS").newLine().plain("$BODY$").newLine().plain(src).newLine().plain("$BODY$").newLine().keyword("LANGUAGE").space().plain(language).space();
            }
            String provolatile = rs.getString("provolatile");
            if ("v".equals(provolatile)) {
                builder.keyword("VOLATILE");
            } else if ("i".equals(provolatile)) {
                builder.keyword("IMMUTABLE");
            } else {
                builder.keyword("STABLE");
            }
            if (rs.getBoolean("proisstrict")) {
                builder.space().keyword("STRICT");
            }
            if (rs.getBoolean("prosecdef")) {
                builder.space().keyword("SECURITY DEFINER");
            }
            builder.newStatement();
        }
        String string = builder.getStatement();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadProcedureDefinition"));
        }
        return string;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/RedshiftDialect", "sqlSequenceDefinition"));
        }
        throw new UnsupportedOperationException("Sequence definition is not supported by Redshift");
    }

    @Override
    public boolean supportsQualifiedAsteriskInCalls() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine2, boolean longMode, boolean withReturn) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDefinePrototype"));
        }
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/dialects/RedshiftDialect", "sqlDefinePrototype"));
        }
        JBIterable parameters = DasUtil.getParameters((DasRoutine)routine2);
        boolean returnsTypeExplicit = false;
        String returnsTypeSpec = null;
        DasArgument returnArg = routine2.getReturnArgument();
        if (returnArg != null) {
            returnsTypeExplicit = true;
            returnsTypeSpec = returnArg.getDataType().getSpecification();
        }
        int outs = 0;
        for (DasArgument parameter : parameters) {
            if (!parameter.getArgumentDirection().isOut()) continue;
            ++outs;
        }
        builder.symbol("(");
        boolean first = true;
        for (DasArgument parameter : parameters) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            DasArgument.Direction argumentDirection = parameter.getArgumentDirection();
            if (longMode || !argumentDirection.isIn()) {
                if (StringUtil.isNotEmpty((String)parameter.getName())) {
                    builder.identifier((DasObject)parameter, parameter.getName()).space();
                }
                if (argumentDirection.isOut()) {
                    if (argumentDirection.isIn()) {
                        builder.keyword("in").space();
                    }
                    builder.keyword("out").space();
                }
            }
            builder.type((DasTypedObject)parameter);
        }
        builder.symbol(")");
        if (!returnsTypeExplicit) {
            if (outs == 1) {
                for (DasArgument parameter : parameters) {
                    if (!parameter.getArgumentDirection().isOut()) continue;
                    returnsTypeSpec = parameter.getDataType().getSpecification();
                }
            } else {
                returnsTypeSpec = "record";
            }
        }
        if (returnsTypeExplicit && withReturn && StringUtil.isNotEmpty((String)returnsTypeSpec)) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type(returnsTypeSpec);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlDefinePrototype"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine routine2) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlDefineProcedure"));
        }
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/dialects/RedshiftDialect", "sqlDefineProcedure"));
        }
        builder.keywords("create", "function").space().qualifiedRef((DasObject)routine2);
        DdlBuilder ddlBuilder = this.sqlDefinePrototype(builder, routine2, true, true);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlDefineProcedure"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/RedshiftDialect", "isValidPlainIdentifier"));
        }
        char c0 = identifier.charAt(0);
        if (!Character.isLetter(c0) && c0 != '_') {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/RedshiftDialect", "qualifiedIdentifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/database/dialects/RedshiftDialect", "qualifiedIdentifier"));
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "qualifiedIdentifier"));
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return false;
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeColumnTypeName", "com/intellij/database/dialects/RedshiftDialect", "getJavaTypeForNativeType"));
        }
        if ("character_data".equalsIgnoreCase(nativeColumnTypeName)) {
            return 1;
        }
        if ("cardinal_number".equalsIgnoreCase(nativeColumnTypeName)) {
            return 4;
        }
        if ("xml".equalsIgnoreCase(nativeColumnTypeName)) {
            return 12;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/RedshiftDialect", "sqlExplainPlan"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dialects/RedshiftDialect", "sqlExplainPlan"));
        }
        builder.keywords("explain").space();
        if (analyze) {
            throw new UnsupportedOperationException("EXPLAIN ANALYZE is not supported by Redshift");
        }
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "sqlExplainPlan"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadDatabaseList"));
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection, "SELECT datname as name FROM pg_database WHERE datistemplate = false", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/RedshiftDialect", "tryToLoadDatabaseList"));
        }
        return list;
    }

    @Override
    public boolean hasRowId(@Nullable DatabaseSystem system) {
        return false;
    }

    @Override
    @Nullable
    public DatabaseDialectEx.VersionParser getVersionParser() {
        return com.intellij.openapi.util.Version::parseVersion;
    }

    @Override
    @Nullable
    public String sqlResetSearchPath() {
        return "set search_path to default";
    }
}

