/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableEditorStructureViewModel
implements StructureViewModel {
    private final Project myProject;
    private final DataGrid myDataGrid;
    private final List<Object> myListeners;
    private final Disposable myDisposable;

    public TableEditorStructureViewModel(@NotNull TableEditorBase editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/editor/TableEditorStructureViewModel", "<init>"));
        }
        this(editor.getProject(), editor.getDataGrid());
    }

    public TableEditorStructureViewModel(@NotNull Project project, @NotNull DataGrid dataGrid) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/TableEditorStructureViewModel", "<init>"));
        }
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/editor/TableEditorStructureViewModel", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDisposable = Disposer.newDisposable();
        this.myProject = project;
        this.myDataGrid = dataGrid;
        this.myDataGrid.addDataGridListener(new DataGridListener(){

            @Override
            public void onSelectionChanged(DataGrid dataGrid) {
                for (Object listener : TableEditorStructureViewModel.this.myListeners) {
                    if (!(listener instanceof FileEditorPositionListener)) continue;
                    ((FileEditorPositionListener)listener).onCurrentElementChanged();
                }
            }

            @Override
            public void onContentChanged(DataGrid dataGrid) {
                for (Object listener : TableEditorStructureViewModel.this.myListeners) {
                    if (!(listener instanceof ModelListener)) continue;
                    ((ModelListener)listener).onModelChanged();
                }
            }
        }, this.myDisposable);
    }

    @Nullable
    public Object getCurrentEditorElement() {
        ModelIndex<DataConsumer.Column> column = this.myDataGrid.getSelectionModel().getSelectedColumn();
        return column.isValid(this.myDataGrid) ? DataGridPomTarget.wrapColumn(this.myProject, this.myDataGrid, column) : null;
    }

    public void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/editor/TableEditorStructureViewModel", "addEditorPositionListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/editor/TableEditorStructureViewModel", "removeEditorPositionListener"));
        }
        this.myListeners.remove(listener);
    }

    public void addModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelListener", "com/intellij/database/editor/TableEditorStructureViewModel", "addModelListener"));
        }
        this.myListeners.add(modelListener);
    }

    public void removeModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelListener", "com/intellij/database/editor/TableEditorStructureViewModel", "removeModelListener"));
        }
        this.myListeners.remove(modelListener);
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        RootElement rootElement = new RootElement();
        if (rootElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel", "getRoot"));
        }
        return rootElement;
    }

    @NotNull
    public Grouper[] getGroupers() {
        if (Grouper.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel", "getGroupers"));
        }
        return Grouper.EMPTY_ARRAY;
    }

    @NotNull
    public Sorter[] getSorters() {
        if (Sorter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel", "getSorters"));
        }
        return Sorter.EMPTY_ARRAY;
    }

    @NotNull
    public Filter[] getFilters() {
        if (Filter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel", "getFilters"));
        }
        return Filter.EMPTY_ARRAY;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }

    private static class ColElement
    extends PsiTreeElementBase<PsiElement>
    implements ColoredItemPresentation,
    LocationPresentation {
        private ColElement(PsiElement element) {
            super(element);
        }

        public void navigate(boolean requestFocus) {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            if (target == null) {
                return;
            }
            target.navigate(requestFocus);
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel$ColElement", "getChildrenBase"));
            }
            return list;
        }

        @Nullable
        public String getPresentableText() {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            DataConsumer.Column column = target != null ? target.getColumn() : null;
            return column != null ? column.name : null;
        }

        public Icon getIcon(boolean open) {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            if (target == null) {
                return DatabaseIcons.Col;
            }
            DasColumn dbColumn = DataGridUtil.getDatabaseColumn(target.dataGrid, target.getColumn());
            return dbColumn == null ? null : DbPresentation.getIcon((DasObject)dbColumn);
        }

        public String getLocationString() {
            char arrow;
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            if (target == null) {
                return null;
            }
            DataGrid dataGrid = target.dataGrid;
            String sqlType = DataGridUtil.getSqlType(dataGrid, target.getColumn());
            RowSortOrder.Type sortOrder = dataGrid.getSortOrder(target.column);
            int thenBySortOrder = dataGrid.getThenBySortOrder(target.column);
            if (sortOrder == RowSortOrder.Type.UNSORTED || thenBySortOrder == 0) {
                return sqlType;
            }
            boolean isAscending = sortOrder == RowSortOrder.Type.ASC;
            char c = arrow = isAscending ? (char)'\u2191' : '\u2193';
            String ordering = UIUtil.getLabelFont().canDisplay(arrow) ? String.valueOf(arrow) : (isAscending ? "A-" : "D-");
            return (StringUtil.isEmpty((String)sqlType) ? "" : sqlType + " ") + ordering + thenBySortOrder;
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        public String getLocationPrefix() {
            return " ";
        }

        public String getLocationSuffix() {
            return "";
        }

        @Nullable
        public TextAttributesKey getTextAttributesKey() {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            ModelIndex<DataConsumer.Column> column = target != null ? target.column : null;
            return column != null && !target.dataGrid.isColumnEnabled(column) ? DatabaseColors.STRUCTURE_HIDDEN_COLUMN : null;
        }
    }

    private class RootElement
    implements StructureViewTreeElement {
        private RootElement() {
        }

        public Object getValue() {
            return this;
        }

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = new PresentationData();
            if (presentationData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel$RootElement", "getPresentation"));
            }
            return presentationData;
        }

        @NotNull
        public TreeElement[] getChildren() {
            GridModel model = TableEditorStructureViewModel.this.myDataGrid.getDataModel(DataAccessType.DATABASE_DATA);
            List columns2 = model.getColumnIndices().asList();
            Project project = TableEditorStructureViewModel.this.myProject;
            TreeElement[] result2 = new TreeElement[columns2.size()];
            for (int i2 = 0; i2 < result2.length; ++i2) {
                result2[i2] = new ColElement(DataGridPomTarget.wrapColumn(project, TableEditorStructureViewModel.this.myDataGrid, (ModelIndex)columns2.get(i2)));
            }
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel$RootElement", "getChildren"));
            }
            return result2;
        }
    }
}

