/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.h2;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.h2.H2Index;
import com.intellij.database.model.h2.H2ModSchema;
import com.intellij.database.model.h2.H2ModTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface H2ModIndex
extends H2Index,
BasicModNamedElement,
BasicModIndex,
BasicModIdentifiedElement {
    @Override
    @NotNull
    public H2ModTable getTable();

    @Override
    @NotNull
    default public H2ModTable getDbParent() {
        H2ModTable h2ModTable = this.getTable();
        if (h2ModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModIndex", "getDbParent"));
        }
        return h2ModTable;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends H2ModIndex> getParentFamily();

    @Override
    @NotNull
    default public H2ModSchema getSchema() {
        H2ModSchema h2ModSchema = this.getTable().getSchema();
        if (h2ModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModIndex", "getSchema"));
        }
        return h2ModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModIndex", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/h2/H2ModIndex", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    @Override
    public void setReverseColNames(@NotNull Set<String> var1);

    @Override
    public void setUnique(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/h2/H2ModIndex", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String colNames = properties.get("ColNames");
        String reverseColNames = properties.get("ReverseColNames");
        String unique = properties.get("Unique");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
        if (reverseColNames != null) {
            this.setReverseColNames(PropertyConverter.importSetOfString(reverseColNames));
        }
        if (unique != null) {
            this.setUnique(PropertyConverter.importBoolean(unique));
        }
    }
}

