/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mssql;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.mssql.MsModLikeMajorTable;
import com.intellij.database.model.mssql.MsModSchemaObject;
import com.intellij.database.model.mssql.MsModSourceAware;
import com.intellij.database.model.mssql.MsTrigger;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MsModTrigger
extends MsTrigger,
MsModSchemaObject,
MsModSourceAware {
    @Override
    @NotNull
    public MsModLikeMajorTable getTable();

    @Override
    @NotNull
    default public MsModLikeMajorTable getDbParent() {
        MsModLikeMajorTable msModLikeMajorTable = this.getTable();
        if (msModLikeMajorTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModTrigger", "getDbParent"));
        }
        return msModLikeMajorTable;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends MsModTrigger> getParentFamily();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModTrigger", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModTrigger", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setEncrypted(boolean var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    public void setEvents(@NotNull Set<TrigEvent> var1);

    public void setFirstEvents(@NotNull Set<TrigEvent> var1);

    public void setLastEvents(@NotNull Set<TrigEvent> var1);

    public void setTurn(@Nullable TrigTurn var1);

    public void setNotForReplication(boolean var1);

    public void setDisabled(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/mssql/MsModTrigger", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String encrypted = properties.get("Encrypted");
        String createdTimestamp = properties.get("CreatedTimestamp");
        String modifiedTimestamp = properties.get("ModifiedTimestamp");
        String events = properties.get("Events");
        String firstEvents = properties.get("FirstEvents");
        String lastEvents = properties.get("LastEvents");
        String turn = properties.get("Turn");
        String notForReplication = properties.get("NotForReplication");
        String disabled = properties.get("Disabled");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (encrypted != null) {
            this.setEncrypted(PropertyConverter.importBoolean(encrypted));
        }
        if (createdTimestamp != null) {
            this.setCreatedTimestamp(PropertyConverter.importDate(createdTimestamp));
        }
        if (modifiedTimestamp != null) {
            this.setModifiedTimestamp(PropertyConverter.importDate(modifiedTimestamp));
        }
        if (events != null) {
            this.setEvents(PropertyConverter.importSetOfTrigEvent(events));
        }
        if (firstEvents != null) {
            this.setFirstEvents(PropertyConverter.importSetOfTrigEvent(firstEvents));
        }
        if (lastEvents != null) {
            this.setLastEvents(PropertyConverter.importSetOfTrigEvent(lastEvents));
        }
        if (turn != null) {
            this.setTurn(PropertyConverter.importTrigTurn(turn));
        }
        if (notForReplication != null) {
            this.setNotForReplication(PropertyConverter.importBoolean(notForReplication));
        }
        if (disabled != null) {
            this.setDisabled(PropertyConverter.importBoolean(disabled));
        }
    }
}

