/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mysql;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.mysql.MysqlModRoot;
import com.intellij.database.model.mysql.MysqlModRoutine;
import com.intellij.database.model.mysql.MysqlModTable;
import com.intellij.database.model.mysql.MysqlModView;
import com.intellij.database.model.mysql.MysqlSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MysqlModSchema
extends MysqlSchema,
BasicModSchema,
BasicModNamedElement {
    @Override
    @NotNull
    public MysqlModRoot getRoot();

    @Override
    @NotNull
    default public MysqlModRoot getDbParent() {
        MysqlModRoot mysqlModRoot = this.getRoot();
        if (mysqlModRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModSchema", "getDbParent"));
        }
        return mysqlModRoot;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends MysqlModSchema> getParentFamily();

    @NotNull
    public ModNamingFamily<? extends MysqlModTable> getTables();

    @NotNull
    public ModNamingFamily<? extends MysqlModView> getViews();

    @NotNull
    public ModNamingFamily<? extends MysqlModRoutine> getRoutines();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getTables(), this.getViews(), this.getRoutines());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModSchema", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getTables()).append((Iterable)this.getViews()).append((Iterable)this.getRoutines());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModSchema", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setIntrospectionTimestamp(@Nullable Date var1);

    @Override
    public void setCurrent(boolean var1);

    @Override
    public void setVisible(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/mysql/MysqlModSchema", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String introspectionTimestamp = properties.get("IntrospectionTimestamp");
        String current = properties.get("Current");
        String visible = properties.get("Visible");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (introspectionTimestamp != null) {
            this.setIntrospectionTimestamp(PropertyConverter.importDate(introspectionTimestamp));
        }
        if (current != null) {
            this.setCurrent(PropertyConverter.importBoolean(current));
        }
        if (visible != null) {
            this.setVisible(PropertyConverter.importBoolean(visible));
        }
    }
}

