/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.oracle.OraModMajorObject;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraSequence;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraModSequence
extends OraSequence,
OraModMajorObject {
    @Override
    @NotNull
    public OraModSchema getSchema();

    @Override
    @NotNull
    default public OraModSchema getDbParent() {
        OraModSchema oraModSchema = this.getSchema();
        if (oraModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModSequence", "getDbParent"));
        }
        return oraModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModSequence> getParentFamily();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModSequence", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModSequence", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    public void setSequenceIdentity(@Nullable SequenceIdentity var1);

    public void setBelongsToColumn(boolean var1);

    public void setOrdered(boolean var1);

    public void setCycled(boolean var1);

    public void setCacheSize(int var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/oracle/OraModSequence", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String createdTimestamp = properties.get("CreatedTimestamp");
        String modifiedTimestamp = properties.get("ModifiedTimestamp");
        String sequenceIdentity = properties.get("SequenceIdentity");
        String belongsToColumn = properties.get("BelongsToColumn");
        String ordered = properties.get("Ordered");
        String cycled = properties.get("Cycled");
        String cacheSize = properties.get("CacheSize");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (createdTimestamp != null) {
            this.setCreatedTimestamp(PropertyConverter.importDate(createdTimestamp));
        }
        if (modifiedTimestamp != null) {
            this.setModifiedTimestamp(PropertyConverter.importDate(modifiedTimestamp));
        }
        if (sequenceIdentity != null) {
            this.setSequenceIdentity(PropertyConverter.importSequenceIdentity(sequenceIdentity));
        }
        if (belongsToColumn != null) {
            this.setBelongsToColumn(PropertyConverter.importBoolean(belongsToColumn));
        }
        if (ordered != null) {
            this.setOrdered(PropertyConverter.importBoolean(ordered));
        }
        if (cycled != null) {
            this.setCycled(PropertyConverter.importBoolean(cycled));
        }
        if (cacheSize != null) {
            this.setCacheSize(PropertyConverter.importInt(cacheSize));
        }
    }
}

