/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresModCheck;
import com.intellij.database.model.postgres.PostgresModForeignKey;
import com.intellij.database.model.postgres.PostgresModIndex;
import com.intellij.database.model.postgres.PostgresModKey;
import com.intellij.database.model.postgres.PostgresModLikeStoredTable;
import com.intellij.database.model.postgres.PostgresModRule;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresModTableColumn;
import com.intellij.database.model.postgres.PostgresModTrigger;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgresbase.PostgresBaseModTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModTable
extends PostgresTable,
PostgresModLikeStoredTable,
PostgresBaseModTable {
    @Override
    @NotNull
    public PostgresModSchema getSchema();

    @Override
    @NotNull
    default public PostgresModSchema getDbParent() {
        PostgresModSchema postgresModSchema = this.getSchema();
        if (postgresModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModTable", "getDbParent"));
        }
        return postgresModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModTable> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends PostgresModTableColumn> getColumns();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModIndex> getIndices();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModKey> getKeys();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModForeignKey> getForeignKeys();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModCheck> getChecks();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModRule> getRules();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModTrigger> getTriggers();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getRules(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append((Iterable)this.getIndices()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys()).append((Iterable)this.getChecks()).append((Iterable)this.getRules()).append((Iterable)this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    @Override
    public void setStateNumber(long var1);

    @Override
    public void setTemporary(boolean var1);

    public void setWithOids(boolean var1);

    public void setAncestorIds(@NotNull List<Long> var1);

    default public void setAncestorIds(Long ... ancestorIds) {
        this.setAncestorIds(Arrays.asList(ancestorIds));
    }

    public void setSuccessorIds(@NotNull Set<Long> var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/postgres/PostgresModTable", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String system = properties.get("System");
        String stateNumber = properties.get("StateNumber");
        String temporary = properties.get("Temporary");
        String withOids = properties.get("WithOids");
        String ancestorIds = properties.get("AncestorIds");
        String successorIds = properties.get("SuccessorIds");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (system != null) {
            this.setSystem(PropertyConverter.importBoolean(system));
        }
        if (stateNumber != null) {
            this.setStateNumber(PropertyConverter.importLong(stateNumber));
        }
        if (temporary != null) {
            this.setTemporary(PropertyConverter.importBoolean(temporary));
        }
        if (withOids != null) {
            this.setWithOids(PropertyConverter.importBoolean(withOids));
        }
        if (ancestorIds != null) {
            this.setAncestorIds(PropertyConverter.importListOfLong(ancestorIds));
        }
        if (successorIds != null) {
            this.setSuccessorIds(PropertyConverter.importSetOfLong(successorIds));
        }
    }
}

