/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresModTable;
import com.intellij.database.model.postgres.PostgresTableColumn;
import com.intellij.database.model.postgresbase.PostgresBaseModTableColumn;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModTableColumn
extends PostgresTableColumn,
PostgresBaseModTableColumn,
BasicModArrangedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public PostgresModTable getTable();

    @Override
    @NotNull
    default public PostgresModTable getDbParent() {
        PostgresModTable postgresModTable = this.getTable();
        if (postgresModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModTableColumn", "getDbParent"));
        }
        return postgresModTable;
    }

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends PostgresModTableColumn> getParentFamily();

    @Override
    @NotNull
    default public PostgresModSchema getSchema() {
        PostgresModSchema postgresModSchema = this.getTable().getSchema();
        if (postgresModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModTableColumn", "getSchema"));
        }
        return postgresModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModTableColumn", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModTableColumn", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setPosition(short var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setDataType(@NotNull DataType var1);

    @Override
    public void setNotNull(boolean var1);

    @Override
    public void setStateNumber(long var1);

    public void setInherited(boolean var1);

    public void setSequenceName(@Nullable String var1);

    @Override
    public void setDefaultExpression(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/postgres/PostgresModTableColumn", "importProperties"));
        }
        String position = properties.get("Position");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String dataType = properties.get("DataType");
        String notNull = properties.get("NotNull");
        String stateNumber = properties.get("StateNumber");
        String inherited = properties.get("Inherited");
        String sequenceName = properties.get("SequenceName");
        String defaultExpression = properties.get("DefaultExpression");
        if (position != null) {
            this.setPosition(PropertyConverter.importShort(position));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (dataType != null) {
            this.setDataType(PropertyConverter.importDataType(dataType));
        }
        if (notNull != null) {
            this.setNotNull(PropertyConverter.importBoolean(notNull));
        }
        if (stateNumber != null) {
            this.setStateNumber(PropertyConverter.importLong(stateNumber));
        }
        if (inherited != null) {
            this.setInherited(PropertyConverter.importBoolean(inherited));
        }
        if (sequenceName != null) {
            this.setSequenceName(PropertyConverter.importString(sequenceName));
        }
        if (defaultExpression != null) {
            this.setDefaultExpression(PropertyConverter.importString(defaultExpression));
        }
    }
}

