/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.redshift;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseOperator;
import com.intellij.database.model.properties.PostgresOperatorKind;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.redshift.RedshiftSchema;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedshiftOperator
extends PostgresBaseOperator,
BasicIdentifiedElement,
BasicNamedElement,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.OPERATOR;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftOperator", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public RedshiftSchema getSchema();

    @Override
    @Nullable
    default public RedshiftSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends RedshiftOperator> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftOperator", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftOperator", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftOperator", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @Override
    @NotNull
    default public PostgresOperatorKind getOperatorKind() {
        PostgresOperatorKind postgresOperatorKind = PostgresOperatorKind.UNKNOWN;
        if (postgresOperatorKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftOperator", "getOperatorKind"));
        }
        return postgresOperatorKind;
    }

    @Override
    @Nullable
    default public String getCallRoutineName() {
        return null;
    }

    @Override
    @NotNull
    default public DataType getLeftType() {
        DataType dataType = ModelConsts.NO_DATA_TYPE;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftOperator", "getLeftType"));
        }
        return dataType;
    }

    @Override
    @NotNull
    default public DataType getRightType() {
        DataType dataType = ModelConsts.NO_DATA_TYPE;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftOperator", "getRightType"));
        }
        return dataType;
    }

    @Override
    @NotNull
    default public DataType getResultType() {
        DataType dataType = ModelConsts.NO_DATA_TYPE;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftOperator", "getResultType"));
        }
        return dataType;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        DataType resultType;
        DataType rightType;
        DataType leftType;
        String callRoutineName;
        PostgresOperatorKind operatorKind;
        long stateNumber;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/redshift/RedshiftOperator", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
        if ((operatorKind = this.getOperatorKind()) != null && operatorKind != PostgresOperatorKind.UNKNOWN) {
            consumer.accept("OperatorKind", PropertyConverter.export(operatorKind));
        }
        if ((callRoutineName = this.getCallRoutineName()) != null) {
            consumer.accept("CallRoutineName", PropertyConverter.export(callRoutineName));
        }
        if ((leftType = this.getLeftType()) != null && leftType != ModelConsts.NO_DATA_TYPE) {
            consumer.accept("LeftType", PropertyConverter.export(leftType));
        }
        if ((rightType = this.getRightType()) != null && rightType != ModelConsts.NO_DATA_TYPE) {
            consumer.accept("RightType", PropertyConverter.export(rightType));
        }
        if ((resultType = this.getResultType()) != null && resultType != ModelConsts.NO_DATA_TYPE) {
            consumer.accept("ResultType", PropertyConverter.export(resultType));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "StateNumber", "OperatorKind", "CallRoutineName", "LeftType", "RightType", "ResultType");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftOperator", "getPropertyNames"));
        }
        return list;
    }
}

