/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.redshift;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.redshift.RedshiftDatabase;
import com.intellij.database.model.redshift.RedshiftDefType;
import com.intellij.database.model.redshift.RedshiftOperator;
import com.intellij.database.model.redshift.RedshiftRoutine;
import com.intellij.database.model.redshift.RedshiftTable;
import com.intellij.database.model.redshift.RedshiftView;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedshiftSchema
extends PostgresBaseSchema,
BasicIdentifiedElement,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SCHEMA;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftSchema", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public RedshiftDatabase getDatabase();

    @Override
    @Nullable
    default public RedshiftDatabase getDbParent() {
        return this.getDatabase();
    }

    @Override
    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends RedshiftSchema> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends RedshiftDefType> getDefTypes();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends RedshiftTable> getTables();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends RedshiftView> getViews();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends RedshiftRoutine> getRoutines();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends RedshiftOperator> getOperators();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.OBJECT_TYPE, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.OPERATOR);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftSchema", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getDefTypes(), this.getTables(), this.getViews(), this.getRoutines(), this.getOperators());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftSchema", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getDefTypes()).append(this.getTables()).append(this.getViews()).append(this.getRoutines()).append(this.getOperators());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftSchema", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public Date getIntrospectionTimestamp() {
        return null;
    }

    @Override
    default public long getIntrospectionStateNumber() {
        return 0L;
    }

    @Override
    default public boolean isCurrent() {
        return false;
    }

    @Override
    default public boolean isVisible() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean visible;
        boolean current;
        long introspectionStateNumber;
        Date introspectionTimestamp;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/redshift/RedshiftSchema", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((introspectionTimestamp = this.getIntrospectionTimestamp()) != null) {
            consumer.accept("IntrospectionTimestamp", PropertyConverter.export(introspectionTimestamp));
        }
        if ((introspectionStateNumber = this.getIntrospectionStateNumber()) != 0L) {
            consumer.accept("IntrospectionStateNumber", PropertyConverter.export(introspectionStateNumber));
        }
        if (current = this.isCurrent()) {
            consumer.accept("Current", PropertyConverter.export(current));
        }
        if (visible = this.isVisible()) {
            consumer.accept("Visible", PropertyConverter.export(visible));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "IntrospectionTimestamp", "IntrospectionStateNumber", "Current", "Visible");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftSchema", "getPropertyNames"));
        }
        return list;
    }
}

