/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sqlite;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.model.sqlite.SqliteKey;
import com.intellij.database.model.sqlite.SqliteModConstraint2;
import com.intellij.database.model.sqlite.SqliteModSchema;
import com.intellij.database.model.sqlite.SqliteModTable;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqliteModKey
extends SqliteKey,
SqliteModConstraint2,
BasicModKey {
    @Override
    @NotNull
    public SqliteModTable getTable();

    @Override
    @NotNull
    default public SqliteModTable getDbParent() {
        SqliteModTable sqliteModTable = this.getTable();
        if (sqliteModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteModKey", "getDbParent"));
        }
        return sqliteModTable;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends SqliteModKey> getParentFamily();

    @Override
    @NotNull
    default public SqliteModSchema getSchema() {
        SqliteModSchema sqliteModSchema = this.getTable().getSchema();
        if (sqliteModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteModKey", "getSchema"));
        }
        return sqliteModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteModKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteModKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    @Override
    public void setOnConflict(@Nullable SqliteOnConflictAlgorithm var1);

    @Override
    public void setPrimary(boolean var1);

    public void setUnderlyingIndexName(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/sqlite/SqliteModKey", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String colNames = properties.get("ColNames");
        String onConflict = properties.get("OnConflict");
        String primary = properties.get("Primary");
        String underlyingIndexName = properties.get("UnderlyingIndexName");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
        if (onConflict != null) {
            this.setOnConflict(PropertyConverter.importSqliteOnConflictAlgorithm(onConflict));
        }
        if (primary != null) {
            this.setPrimary(PropertyConverter.importBoolean(primary));
        }
        if (underlyingIndexName != null) {
            this.setUnderlyingIndexName(PropertyConverter.importString(underlyingIndexName));
        }
    }
}

