/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbKIFKImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class DbIndexImpl
extends DbKIFKImpl<DasIndex>
implements DbIndex {
    public DbIndexImpl(DbTable parent, DasIndex info) {
        super(parent, info);
    }

    @Override
    protected MultiRef<? extends DasTypedObject> getDelegateColumnsRef() {
        return ((DasIndex)this.getDelegate()).getColumnsRef();
    }

    @NotNull
    public DasIndex.Sorting getColumnSorting(@NotNull DasTypedObject column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/psi/DbIndexImpl", "getColumnSorting"));
        }
        DbElement dbColumn = (DbElement)ObjectUtils.tryCast((Object)column, DbElement.class);
        DasTypedObject delegateColumn = dbColumn == null ? null : (DasTypedObject)ObjectUtils.tryCast((Object)dbColumn.getDelegate(), DasTypedObject.class);
        DasIndex.Sorting sorting = delegateColumn == null ? DasIndex.Sorting.NONE : ((DasIndex)this.getDelegate()).getColumnSorting(delegateColumn);
        if (sorting == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbIndexImpl", "getColumnSorting"));
        }
        return sorting;
    }

    @Override
    public boolean isUnique() {
        return ((DasIndex)this.getDelegate()).isUnique();
    }

    public boolean isFunctionBased() {
        return ((DasIndex)this.getDelegate()).isFunctionBased();
    }
}

