/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbRoutineImpl
extends DbElementImpl<DasRoutine, DbElement>
implements DbRoutine {
    protected DbRoutineImpl(DbElement parent, DasRoutine delegate) {
        super(parent, delegate);
    }

    public String getPackageName() {
        return ((DasRoutine)this.myDelegate).getPackageName();
    }

    @NotNull
    public DasRoutine.Kind getRoutineKind() {
        DasRoutine.Kind kind = ((DasRoutine)this.myDelegate).getRoutineKind();
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbRoutineImpl", "getRoutineKind"));
        }
        return kind;
    }

    @NotNull
    public Iterable<? extends DasArgument> getArguments() {
        Iterable iterable = ((DasRoutine)this.myDelegate).getArguments();
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbRoutineImpl", "getArguments"));
        }
        return iterable;
    }

    @Nullable
    public DasArgument getReturnArgument() {
        return ((DasRoutine)this.myDelegate).getReturnArgument();
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation() {
        DdlBuilder.Colored colored = this.createDocHeaderColored();
        StringBuilder sb = colored.cast(StringBuilder.class);
        if (!this.appendDefinition(sb)) {
            colored.plain("<br><code><pre>");
            colored.element((DasObject)this);
            colored.plain("</pre></code><br>");
            if (DbImplUtil.canConnectTo(this) && DbImplUtil.getDatabaseDialect(this).supportsProcedureDefinition()) {
                this.scheduleAsyncDocumentationUpdate(sb, this::loadSlowDocumentationInner);
            }
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbRoutineImpl", "getDocumentation"));
        }
        return stringBuilder;
    }

    private void loadSlowDocumentationInner(CharOut sb, ConnectionProvider provider) throws Exception {
        sb.append("<br>");
        StringBuilder builder = new StringBuilder();
        DbImplUtil.tryLoadProcedureDefinition(provider, this, builder);
        if (!builder.toString().trim().isEmpty()) {
            sb.append("<b>Definition:</b><br><code><pre>");
            sb.append(this.sql2Html(builder));
            sb.append("</pre></code>");
        } else {
            sb.append("<b>No definition found</b>");
        }
    }
}

