/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.GridSearchSession;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.EditorHeaderToggleAction;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.editorHeaderActions.ToggleWholeWordsOnlyAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridSearchSession
implements GridSearchSession<DataConsumer.Row, DataConsumer.Column>,
DataProvider,
SearchReplaceComponent.Listener,
FindModel.FindModelObserver {
    private static final String FILTERING_ENABLED_PROPERTY = "grid.search.filter.rows";
    private final Project myProject;
    private final DataGrid myGrid;
    private final FindModel myFindModel;
    private final SearchReplaceComponent mySearchComponent;
    private final Component myPreviousTopComponent;
    private final EventDispatcher<GridSearchSession.Listener> myDispatcher;
    private boolean myFilteringEnabled;

    public DataGridSearchSession(@Nullable Project project, @NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/DataGridSearchSession", "<init>"));
        }
        this.myDispatcher = EventDispatcher.create(GridSearchSession.Listener.class);
        this.myProject = project;
        this.myGrid = grid;
        this.mySearchComponent = this.createSearchComponent();
        this.myPreviousTopComponent = grid.getTopComponent();
        this.myFindModel = this.createFindModel();
        this.myFilteringEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(FILTERING_ENABLED_PROPERTY);
        this.myGrid.setTopComponent((Component)this.mySearchComponent);
        this.myGrid.searchSessionStarted(this);
        UIUtil.putClientProperty((JComponent)this.mySearchComponent, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)new Iterable<Component>(){

            @Override
            @NotNull
            public Iterator<Component> iterator() {
                Component component = DataGridSearchSession.this.myPreviousTopComponent;
                if (component != null && component.getParent() == null) {
                    Iterator<Component> iterator = Collections.singleton(component).iterator();
                    if (iterator == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/DataGridSearchSession$1", "iterator"));
                    }
                    return iterator;
                }
                Iterator iterator = ContainerUtil.emptyIterator();
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/DataGridSearchSession$1", "iterator"));
                }
                return iterator;
            }
        });
    }

    @NotNull
    private FindModel createFindModel() {
        FindModel findModel = new FindModel();
        findModel.copyFrom(FindManager.getInstance((Project)this.myProject).getFindInFileModel());
        findModel.addObserver((FindModel.FindModelObserver)this);
        FindModel findModel2 = findModel;
        if (findModel2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/DataGridSearchSession", "createFindModel"));
        }
        return findModel2;
    }

    @NotNull
    private SearchReplaceComponent createSearchComponent() {
        SearchReplaceComponent searchReplaceComponent = SearchReplaceComponent.buildFor((Project)this.myProject, (JComponent)this.myGrid.getComponent()).addPrimarySearchActions(new AnAction[]{new PrevOccurrenceAction(), new NextOccurrenceAction()}).addExtraSearchActions(new AnAction[]{new ToggleMatchCase(), new ToggleRegex(), new ToggleWholeWordsOnlyAction(), new ToggleFilteringAction(), new StatusTextAction()}).withCloseAction(this::close).withDataProvider((DataProvider)this).build();
        searchReplaceComponent.addListener((SearchReplaceComponent.Listener)this);
        SearchReplaceComponent searchReplaceComponent2 = searchReplaceComponent;
        if (searchReplaceComponent2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/DataGridSearchSession", "createSearchComponent"));
        }
        return searchReplaceComponent2;
    }

    @NotNull
    public SearchReplaceComponent getComponent() {
        SearchReplaceComponent searchReplaceComponent = this.mySearchComponent;
        if (searchReplaceComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/DataGridSearchSession", "getComponent"));
        }
        return searchReplaceComponent;
    }

    @Override
    public boolean isMatchedCell(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (rowIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/run/ui/grid/DataGridSearchSession", "isMatchedCell"));
        }
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/grid/DataGridSearchSession", "isMatchedCell"));
        }
        return FindManager.getInstance((Project)this.myProject).findString((CharSequence)this.getText(rowIdx, columnIdx), 0, this.myFindModel).isStringFound();
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.myFilteringEnabled && this.isFilteringAvailable();
    }

    @Override
    public void addListener(@NotNull GridSearchSession.Listener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/run/ui/grid/DataGridSearchSession", "addListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/run/ui/grid/DataGridSearchSession", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    public void searchFieldDocumentChanged() {
        String textToFind = this.mySearchComponent.getSearchTextComponent().getText();
        this.myFindModel.setStringToFind(textToFind);
        this.myFindModel.setMultiline(textToFind.contains("\n"));
        this.fireSessionUpdated();
    }

    public void replaceFieldDocumentChanged() {
    }

    public void multilineStateChanged() {
        this.myFindModel.setMultiline(this.mySearchComponent.isMultiline());
    }

    @NotNull
    public FindModel getFindModel() {
        FindModel findModel = this.myFindModel;
        if (findModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/DataGridSearchSession", "getFindModel"));
        }
        return findModel;
    }

    public boolean hasMatches() {
        return this.findOccurrence(true, true) != null;
    }

    public void searchForward() {
        this.selectOccurrence(false, true);
    }

    public void searchBackward() {
        this.selectOccurrence(false, false);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (SearchSession.KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    public void findModelChanged(FindModel findModel) {
        String stringToFind = this.myFindModel.getStringToFind();
        boolean incorrectRegex = this.myFindModel.isRegularExpressions() && this.myFindModel.compileRegExp() == null;
        boolean hasMatches = this.hasMatches();
        if (incorrectRegex || StringUtil.isNotEmpty((String)stringToFind) && !hasMatches) {
            this.mySearchComponent.setNotFoundBackground();
        } else {
            this.mySearchComponent.setRegularBackground();
        }
        this.mySearchComponent.setStatusText(incorrectRegex ? "Incorrect regular expression" : "");
        this.mySearchComponent.update(stringToFind, "", false, this.myFindModel.isMultiline());
        if (hasMatches) {
            this.selectOccurrence(true, true);
        }
        FindUtil.updateFindInFileModel((Project)this.myProject, (FindModel)this.myFindModel, (boolean)false);
        this.fireSessionUpdated();
    }

    public void close() {
        this.myGrid.setTopComponent(this.myPreviousTopComponent);
        this.myGrid.searchSessionStopped(this);
    }

    private void fireSessionUpdated() {
        ((GridSearchSession.Listener)this.myDispatcher.getMulticaster()).searchSessionUpdated();
    }

    private boolean isFilteringAvailable() {
        return !this.myGrid.isTransposed();
    }

    private void selectOccurrence(boolean selectCurrent, boolean next) {
        Pair.NonNull<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>> cell = this.findOccurrence(selectCurrent, next);
        if (cell != null) {
            SelectionModel selectionModel = this.myGrid.getSelectionModel();
            selectionModel.setRowSelection((ModelIndex)cell.first);
            selectionModel.setColumnSelection((ModelIndex)cell.second);
        }
    }

    @Nullable
    private Pair.NonNull<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>> findOccurrence(boolean findCurrent, boolean forward) {
        List rows = this.myGrid.getVisibleRows().asList();
        List columns2 = this.myGrid.getVisibleColumns().asList();
        if (rows.isEmpty() || columns2.isEmpty()) {
            return null;
        }
        int startRowIdx = rows.indexOf(this.myGrid.getSelectionModel().getSelectedRow());
        int startColumnIdx = columns2.indexOf(this.myGrid.getSelectionModel().getSelectedColumn());
        if (startRowIdx == -1 || startColumnIdx == -1) {
            startRowIdx = 0;
            startColumnIdx = 0;
        }
        int indicesCount = columns2.size() * rows.size();
        int startIdx = columns2.size() * startRowIdx + startColumnIdx;
        int currentIdx = startIdx = findCurrent ? startIdx : DataGridSearchSession.nextIdx(startIdx, forward, indicesCount);
        for (int cellsExplored = 0; cellsExplored != indicesCount; ++cellsExplored) {
            ModelIndex column;
            ModelIndex row = (ModelIndex)rows.get(currentIdx / columns2.size());
            if (this.isMatchedCell(row, column = (ModelIndex)columns2.get(currentIdx % columns2.size()))) {
                return new Pair.NonNull((Object)row, (Object)column);
            }
            currentIdx = DataGridSearchSession.nextIdx(currentIdx, forward, indicesCount);
        }
        return null;
    }

    private static int nextIdx(int idx, boolean forward, int indicesCount) {
        int nextIdx = (idx + (forward ? 1 : -1)) % indicesCount;
        return nextIdx < 0 ? nextIdx + indicesCount : nextIdx;
    }

    @NotNull
    private String getText(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (rowIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/run/ui/grid/DataGridSearchSession", "getText"));
        }
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/grid/DataGridSearchSession", "getText"));
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> model = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        DataConsumer.Row row = (DataConsumer.Row)ObjectUtils.assertNotNull((Object)model.getRow(rowIdx));
        DataConsumer.Column column = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)model.getColumn(columnIdx));
        String string = this.getText(row, column);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/DataGridSearchSession", "getText"));
        }
        return string;
    }

    @NotNull
    private String getText(DataConsumer.Row row, DataConsumer.Column column) {
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(this.myGrid);
        String string = this.myGrid.getObjectFormatter().getPlainValue(column, row, (DatabaseDialect)dialect);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/DataGridSearchSession", "getText"));
        }
        return string;
    }

    private class ToggleFilteringAction
    extends EditorHeaderToggleAction {
        protected ToggleFilteringAction() {
            super("&Filter rows");
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(DataGridSearchSession.this.isFilteringAvailable());
        }

        protected boolean isSelected(@NotNull SearchSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/run/ui/grid/DataGridSearchSession$ToggleFilteringAction", "isSelected"));
            }
            return DataGridSearchSession.this.myFilteringEnabled && DataGridSearchSession.this.isFilteringAvailable();
        }

        protected void setSelected(@NotNull SearchSession session, boolean selected) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/run/ui/grid/DataGridSearchSession$ToggleFilteringAction", "setSelected"));
            }
            boolean wasEnabled = DataGridSearchSession.this.myFilteringEnabled;
            DataGridSearchSession.this.myFilteringEnabled = selected;
            if (wasEnabled != selected) {
                DataGridSearchSession.this.fireSessionUpdated();
            }
            PropertiesComponent.getInstance((Project)DataGridSearchSession.this.myProject).setValue(DataGridSearchSession.FILTERING_ENABLED_PROPERTY, DataGridSearchSession.this.myFilteringEnabled);
        }
    }
}

