/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridSelection {
    private final int[] myRows;
    private final int[] myColumns;
    private int[] myAdditionalColumns;
    private int[] myAdditionalRows;

    private GridSelection(int[] rows, int[] columns2) {
        this.myRows = rows;
        this.myColumns = columns2;
    }

    @NotNull
    public static GridSelection store(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "store"));
        }
        GridSelection gridSelection = new GridSelection(GridSelection.convert(table.getRowCount(), table::convertRowIndexToModel, table.getSelectedRows()), GridSelection.convert(table.getColumnCount(), table::convertColumnIndexToModel, table.getSelectedColumns()));
        if (gridSelection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridSelection", "store"));
        }
        return gridSelection;
    }

    public void restore(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "restore"));
        }
        table.clearSelection();
        GridSelection.setColumnSelection(table, GridSelection.convert(table.getModel().getColumnCount(), table::convertColumnIndexToView, this.getColumns()));
        GridSelection.setRowSelection(table, GridSelection.convert(table.getModel().getRowCount(), table::convertRowIndexToView, this.getRows()));
    }

    @NotNull
    public GridSelection fit(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "fit"));
        }
        int rowCount = table.getRowCount();
        int columnCount = table.getColumnCount();
        GridSelection.fit(this.myRows, rowCount);
        GridSelection.fit(this.myColumns, columnCount);
        GridSelection.fit(this.myAdditionalRows, rowCount);
        GridSelection.fit(this.myAdditionalColumns, columnCount);
        GridSelection gridSelection = this;
        if (gridSelection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridSelection", "fit"));
        }
        return gridSelection;
    }

    public GridSelection transpose() {
        return new GridSelection(this.myColumns, this.myRows);
    }

    public void addSelectedColumns(int ... additionalColumns) {
        this.myAdditionalColumns = additionalColumns;
    }

    public void addSelectedRows(int ... additionalRows) {
        this.myAdditionalRows = additionalRows;
    }

    public static void setColumnSelection(@NotNull JTable table, int ... selection) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "setColumnSelection"));
        }
        GridSelection.setSelection(table.getColumnModel().getSelectionModel(), false, table.getColumnCount() - 1, selection);
    }

    public static void setRowSelection(@NotNull JTable table, int ... selection) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "setRowSelection"));
        }
        GridSelection.setSelection(table.getSelectionModel(), false, table.getRowCount() - 1, selection);
    }

    public static void addRowSelection(@NotNull JTable table, int ... selection) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "addRowSelection"));
        }
        GridSelection.setSelection(table.getSelectionModel(), true, table.getRowCount() - 1, selection);
    }

    private static void setSelection(ListSelectionModel selectionModel, boolean add, int maxSelectionIdx, int ... selection) {
        if (maxSelectionIdx < 0) {
            return;
        }
        if (!add) {
            selectionModel.clearSelection();
        }
        for (int index : selection) {
            GridSelection.setSelectionInterval(selectionModel, true, maxSelectionIdx, index, index);
        }
    }

    public static void setColumnSelectionInterval(@NotNull JTable table, int idx0, int idx1) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "setColumnSelectionInterval"));
        }
        GridSelection.setSelectionInterval(table.getColumnModel().getSelectionModel(), false, table.getColumnCount() - 1, idx0, idx1);
    }

    public static void addColumnSelectionInterval(@NotNull JTable table, int idx0, int idx1) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "addColumnSelectionInterval"));
        }
        GridSelection.setSelectionInterval(table.getColumnModel().getSelectionModel(), true, table.getColumnCount() - 1, idx0, idx1);
    }

    public static void setRowSelectionInterval(@NotNull JTable table, int idx0, int idx1) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "setRowSelectionInterval"));
        }
        GridSelection.setSelectionInterval(table.getSelectionModel(), false, table.getRowCount() - 1, idx0, idx1);
    }

    public static void addRowSelectionInterval(@NotNull JTable table, int idx0, int idx1) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridSelection", "addRowSelectionInterval"));
        }
        GridSelection.setSelectionInterval(table.getSelectionModel(), true, table.getRowCount() - 1, idx0, idx1);
    }

    private static void fit(@Nullable int[] indices, int max) {
        if (indices == null) {
            return;
        }
        for (int i2 = 0; i2 < indices.length; ++i2) {
            if (indices[i2] < max) continue;
            indices[i2] = max - 1;
        }
    }

    private static void setSelectionInterval(ListSelectionModel selectionModel, boolean add, int maxSelectionIdx, int idx0, int idx1) {
        if (maxSelectionIdx < 0) {
            return;
        }
        idx0 = GridSelection.index(idx0, maxSelectionIdx);
        idx1 = GridSelection.index(idx1, maxSelectionIdx);
        if (add) {
            selectionModel.addSelectionInterval(idx0, idx1);
        } else {
            selectionModel.setSelectionInterval(idx0, idx1);
        }
    }

    private static int index(int idx, int maxIdx) {
        return Math.max(0, Math.min(idx, maxIdx));
    }

    private int[] getColumns() {
        return this.myAdditionalColumns != null ? ArrayUtil.mergeArrays((int[])this.myColumns, (int[])this.myAdditionalColumns) : this.myColumns;
    }

    private int[] getRows() {
        return this.myAdditionalRows != null ? ArrayUtil.mergeArrays((int[])this.myRows, (int[])this.myAdditionalRows) : this.myRows;
    }

    private static int[] convert(int maxIndex, IntUnaryOperator function, int[] indices) {
        return Arrays.stream(indices).filter(index -> index < maxIndex && index >= 0).map(function).filter(index -> index != -1).toArray();
    }
}

