/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatter;
import com.intellij.database.run.ui.grid.editors.DefaultTimeEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.util.DbImplUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class TimeZonedTimeEditorFactory
extends DefaultTimeEditorFactory {
    @Override
    @NotNull
    protected Formatter getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/TimeZonedTimeEditorFactory", "getFormat"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/TimeZonedTimeEditorFactory", "getFormat"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/TimeZonedTimeEditorFactory", "getFormat"));
        }
        DateAndTimeFormatter dateAndTimeFormatter = grid.getObjectFormatter().getZonedTimeFormat();
        if (dateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/TimeZonedTimeEditorFactory", "getFormat"));
        }
        return dateAndTimeFormatter;
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/TimeZonedTimeEditorFactory", "getSuitability"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/TimeZonedTimeEditorFactory", "getSuitability"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/TimeZonedTimeEditorFactory", "getSuitability"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column));
        return DbImplUtil.isZonedTimeColumn(c, DataGridUtil.getDatabaseDialect(grid)) ? 2 : 0;
    }
}

