/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.postgres;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeRoutine;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgRenameRoutineOperation
extends DasDdlOperations.DdlOperationGeneratorSimple<DeRoutine> {
    public PgRenameRoutineOperation() {
        super(DasDdlOperations.RENAME_ROUTINE, DeRoutine.class, ObjectKind.ROUTINE);
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeRoutine object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/postgres/PgRenameRoutineOperation", "generate"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/postgres/PgRenameRoutineOperation", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/postgres/PgRenameRoutineOperation", "generate"));
        }
        DeObject target = this.getTarget(data);
        String name = target.getName();
        builder.keywords("ALTER", "FUNCTION").space().qualifiedRef(object);
        builder.getDialect().sqlDefinePrototype(builder, object, true, false).space();
        DdlBuilder ddlBuilder = builder.keywords("RENAME", "TO").space().identifier(object, name);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/postgres/PgRenameRoutineOperation", "generate"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public JBIterable<DdlOperationKey> getImplemented(@NotNull DeRoutine object, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/postgres/PgRenameRoutineOperation", "getImplemented"));
        }
        JBIterable<DdlOperationKey> jBIterable = DdlGraph.notNullize(new DdlOperationKey(this.getTarget(data), DdlOperation.POST_RENAME));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/postgres/PgRenameRoutineOperation", "getImplemented"));
        }
        return jBIterable;
    }

    @NotNull
    public DeObject getTarget(@Nullable UserDataHolder data) {
        DeObject deObject = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
        if (deObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/postgres/PgRenameRoutineOperation", "getTarget"));
        }
        return deObject;
    }
}

