/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.serialization;

import com.intellij.database.serialization.ModelElementMem;
import com.intellij.database.serialization.ModelMem;
import com.intellij.database.serialization.MutableNameAndValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Redshift;
import org.jetbrains.dekaf.Sybase;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\f\n\u0000\u001a$\u0010\u0004\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u0007*\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\b\u001a\u00020\t\u001a(\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\t\u001a%\u0010\u0013\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\u0014\b\u0004\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u0015H\u0086\b\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001b\u0010\u0013\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e\u001a \u0010\u001a\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\t\u001a\u000e\u0010\u001c\u001a\u0004\u0018\u00010\t*\u0004\u0018\u00010\t\u001a\u0018\u0010\u001d\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u001e\u001a\u0004\u0018\u00010\t*\u0004\u0018\u00010\t\u001a\u0017\u0010\u001f\u001a\u00020\u0001*\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020!H\u0086\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\""}, d2={"isMultiDatabase", "", "Lorg/jetbrains/dekaf/Rdbms;", "(Lorg/jetbrains/dekaf/Rdbms;)Z", "add", "", "", "Lcom/intellij/database/serialization/MutableNameAndValue;", "name", "", "value", "find", "", "findChildOf", "Lcom/intellij/database/serialization/ModelElementMem;", "Lcom/intellij/database/serialization/ModelMem;", "element", "childKind", "childName", "findElement", "predicate", "Lkotlin/Function1;", "id", "", "(Lcom/intellij/database/serialization/ModelMem;Ljava/lang/Integer;)Lcom/intellij/database/serialization/ModelElementMem;", "findParentOf", "findSibling", "siblingName", "normalize", "remove", "safeRTrim", "startsWith", "c", "", "database-introspection"})
@JvmName(name="ModelSerializationFun")
public final class ModelSerializationFun {
    public static final boolean isMultiDatabase(@NotNull Rdbms $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver, (Object)Postgres.RDBMS) || Intrinsics.areEqual((Object)$receiver, (Object)Redshift.RDBMS) || Intrinsics.areEqual((Object)$receiver, (Object)Mssql.RDBMS) || Intrinsics.areEqual((Object)$receiver, (Object)Sybase.RDBMS);
    }

    @Nullable
    public static final String normalize(@Nullable String $receiver) {
        String str = ModelSerializationFun.safeRTrim($receiver);
        if (str != null && str.length() == 0) {
            return null;
        }
        return str;
    }

    @Nullable
    public static final String safeRTrim(@Nullable String $receiver) {
        String string;
        int n;
        char c;
        int p;
        if ($receiver == null) {
            return null;
        }
        for (p = n = $receiver.length(); p > 0 && Character.isWhitespace(c = $receiver.charAt(p - 1)) && c != '\n'; --p) {
        }
        if (p == n) {
            string = $receiver;
        } else {
            String string2 = $receiver;
            int n2 = 0;
            String string3 = string2.substring(n2, p);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        return string;
    }

    public static final boolean startsWith(@Nullable String $receiver, char c) {
        return $receiver != null && $receiver.length() != 0 && $receiver.charAt(0) == c;
    }

    @Nullable
    public static final ModelElementMem findElement(@NotNull ModelMem $receiver, @NotNull Function1<? super ModelElementMem, Boolean> predicate) {
        Object v0;
        block1: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
            Iterable iterable2 = iterable = (Iterable)$receiver.getNodes();
            for (Object t : iterable2) {
                if (!((Boolean)predicate.invoke(t)).booleanValue()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final ModelElementMem findElement(@NotNull ModelMem $receiver, int id) {
        Object v0;
        block1: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Iterable iterable2 = iterable = (Iterable)$receiver.getNodes();
            for (Object t : iterable2) {
                ModelElementMem it = (ModelElementMem)t;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final ModelElementMem findElement(@NotNull ModelMem $receiver, @Nullable Integer id) {
        ModelElementMem modelElementMem;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (id != null) {
            Object v0;
            block3: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)$receiver.getNodes();
                for (Object t : iterable2) {
                    ModelElementMem it = (ModelElementMem)t;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            modelElementMem = v0;
        } else {
            modelElementMem = null;
        }
        return modelElementMem;
    }

    @Nullable
    public static final ModelElementMem findParentOf(@NotNull ModelMem $receiver, @Nullable ModelElementMem element) {
        ModelElementMem modelElementMem;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (element != null) {
            Object v0;
            block3: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)$receiver.getNodes();
                for (Object t : iterable2) {
                    ModelElementMem it = (ModelElementMem)t;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)element.getParentId())) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            modelElementMem = v0;
        } else {
            modelElementMem = null;
        }
        return modelElementMem;
    }

    @Nullable
    public static final ModelElementMem findSibling(@NotNull ModelMem $receiver, @Nullable ModelElementMem element, @Nullable String siblingName) {
        ModelElementMem modelElementMem;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (element != null && siblingName != null) {
            Object v0;
            block3: {
                Iterable iterable;
                ModelMem $receiver$iv = $receiver;
                Iterable iterable2 = iterable = (Iterable)$receiver$iv.getNodes();
                for (Object t : iterable2) {
                    ModelElementMem it = (ModelElementMem)t;
                    if (!(Intrinsics.areEqual((Object)it.getParentId(), (Object)element.getParentId()) && Intrinsics.areEqual((Object)it.getKind(), (Object)element.getKind()) && Intrinsics.areEqual((Object)it.getName(), (Object)siblingName))) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            modelElementMem = v0;
        } else {
            modelElementMem = null;
        }
        return modelElementMem;
    }

    @Nullable
    public static final ModelElementMem findChildOf(@NotNull ModelMem $receiver, @Nullable ModelElementMem element, @NotNull String childKind, @Nullable String childName) {
        ModelElementMem modelElementMem;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)childKind, (String)"childKind");
        if (element != null && childName != null) {
            Object v0;
            block3: {
                Iterable iterable;
                ModelMem $receiver$iv = $receiver;
                Iterable iterable2 = iterable = (Iterable)$receiver$iv.getNodes();
                for (Object t : iterable2) {
                    ModelElementMem it = (ModelElementMem)t;
                    if (!(Intrinsics.areEqual((Object)it.getParentId(), (Object)element.getId()) && Intrinsics.areEqual((Object)it.getKind(), (Object)childKind) && Intrinsics.areEqual((Object)it.getName(), (Object)childName))) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            modelElementMem = v0;
        } else {
            modelElementMem = null;
        }
        return modelElementMem;
    }

    public static final void add(@NotNull List<MutableNameAndValue> $receiver, @Nullable String name, @Nullable String value) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (name == null || value == null) {
            return;
        }
        MutableNameAndValue item = new MutableNameAndValue(name, value);
        $receiver.add(item);
    }

    public static final void remove(@NotNull List<MutableNameAndValue> $receiver, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        MutableNameAndValue p = ModelSerializationFun.find($receiver, name);
        if (p != null) {
            $receiver.remove(p);
        }
    }

    @Nullable
    public static final MutableNameAndValue find(@NotNull List<MutableNameAndValue> $receiver, @NotNull String name) {
        Object v0;
        block1: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Iterable iterable2 = iterable = (Iterable)$receiver;
            for (Object t : iterable2) {
                MutableNameAndValue it = (MutableNameAndValue)t;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

