/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DataBus;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class AbstractDatabaseModifier {
    @Nullable
    private final LocalDataSource myLocalDataSource;
    @NotNull
    protected DbDataSource myDataSource;
    @NotNull
    private LoaderContext myContext;
    @NotNull
    private final String myTitle;
    @Nullable
    private final DasNamespace myDefaultNs;
    private final ErrorHandler myErrorHandler;

    protected AbstractDatabaseModifier(@NotNull DbDataSource dataSource, @Nullable DasNamespace defaultNs, @NotNull String title) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/view/AbstractDatabaseModifier", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/view/AbstractDatabaseModifier", "<init>"));
        }
        this.myErrorHandler = new ErrorHandler();
        this.myDataSource = dataSource;
        this.myDefaultNs = defaultNs;
        this.myTitle = title;
        DatabaseSystem delegate = dataSource.getDelegate();
        this.myLocalDataSource = (LocalDataSource)ObjectUtils.tryCast((Object)delegate, LocalDataSource.class);
        this.myContext = new LoaderContext(dataSource.getProject(), this.myLocalDataSource == null ? new LocalDataSource() : this.myLocalDataSource);
    }

    @NotNull
    public DbDataSource getDataSource() {
        DbDataSource dbDataSource = this.myDataSource;
        if (dbDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "getDataSource"));
        }
        return dbDataSource;
    }

    @NotNull
    public LoaderContext getContext() {
        LoaderContext loaderContext = this.myContext;
        if (loaderContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "getContext"));
        }
        return loaderContext;
    }

    @NotNull
    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = this.myErrorHandler;
        if (errorHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "getErrorHandler"));
        }
        return errorHandler;
    }

    @NotNull
    public CompletionStage<Void> runStatements(boolean nonModalSync) {
        if (this.myLocalDataSource == null) {
            CompletableFuture<Void> completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "runStatements"));
            }
            return completableFuture;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator == null) {
            ProgressIndicatorEx backgroundIndicator = AsyncUtil.createBackgroundIndicator(this.myDataSource.getProject(), this.myTitle);
            CompletionStage<Void> completionStage = AsyncUtil.runTask(() -> this.runStatementsInner(nonModalSync, (ProgressIndicator)backgroundIndicator), backgroundIndicator);
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "runStatements"));
            }
            return completionStage;
        }
        CompletionStage<Void> completionStage = this.runStatementsInner(nonModalSync, indicator);
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "runStatements"));
        }
        return completionStage;
    }

    @NotNull
    protected CompletionStage<Void> runStatementsInner(boolean nonModalSync, ProgressIndicator indicator) {
        CompletionStage<Void> completionStage;
        Project project = this.myDataSource.getProject();
        DataRequest.OwnerEx owner = DataRequest.newOwnerEx(this.myDataSource.getProject());
        try {
            JdbcEngine engine = new JdbcEngine(this.myDataSource.getProject(), DataBus.shortCircuit(owner.getMessageBus()), this.myContext.getDataSource(), null, true);
            Disposer.register((Disposable)owner, (Disposable)engine);
            owner.getMessageBus().addAuditor(new DataAuditor.Adapter(){

                @Override
                public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th1) {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/AbstractDatabaseModifier$1", "error"));
                    }
                    AbstractDatabaseModifier.this.myErrorHandler.addError(message, th1);
                }
            });
            completionStage = this.scheduleRequests(indicator, owner, engine).handleAsync((r, th) -> {
                Disposer.dispose((Disposable)owner);
                if (nonModalSync) {
                    ApplicationManager.getApplication().invokeLater(() -> this.runSync(), ModalityState.NON_MODAL);
                } else {
                    AsyncUtil.underProgress(this::runSync, indicator);
                }
                AsyncUtil.addUnhandledError(this.myErrorHandler, th, this.myTitle, DbImplUtil.getDatabaseDialect((DbElement)this.myDataSource).getFamilyId());
                if (!this.myErrorHandler.getSummary().isEmpty()) {
                    DataSourceUiUtil.showNotification(project, "", this.myErrorHandler.getSummary(), true);
                }
                if (th != null || this.myErrorHandler.hasErrors()) {
                    throw new ProcessCanceledException();
                }
                return r;
            }, AsyncUtil.EDT_EXECUTOR);
        }
        catch (Throwable th2) {
            Disposer.dispose((Disposable)owner);
            throw th2;
        }
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "runStatementsInner"));
        }
        return completionStage;
    }

    @NotNull
    private static CompletionStage<Void> wrap(@NotNull Promise<Void> res) {
        if (res == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "res", "com/intellij/database/view/AbstractDatabaseModifier", "wrap"));
        }
        CompletableFuture<Void> result2 = new CompletableFuture<Void>();
        res.done(x -> result2.complete((Void)x));
        res.rejected(x -> result2.completeExceptionally((Throwable)x));
        CompletableFuture<Void> completableFuture = result2;
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "wrap"));
        }
        return completableFuture;
    }

    @NotNull
    public CompletionStage<Void> scheduleRequests(@NotNull ProgressIndicator indicator, @NotNull DataRequest.OwnerEx owner, @NotNull JdbcEngine engine) {
        Promise res;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/AbstractDatabaseModifier", "scheduleRequests"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/view/AbstractDatabaseModifier", "scheduleRequests"));
        }
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/database/view/AbstractDatabaseModifier", "scheduleRequests"));
        }
        SearchPath path = SearchPath.of(ObjectPath.of((DasObject)this.myDefaultNs));
        if (path == null) {
            res = this.getExecutor().execute(indicator, owner, engine, this.myErrorHandler);
        } else {
            DataRequest request = DataRequest.newSchemaSwitchRequest(owner, path, false);
            res = request.getPromise().thenAsync(x -> {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/AbstractDatabaseModifier", "lambda$scheduleRequests$5"));
                }
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/view/AbstractDatabaseModifier", "lambda$scheduleRequests$5"));
                }
                if (engine == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/database/view/AbstractDatabaseModifier", "lambda$scheduleRequests$5"));
                }
                return this.getExecutor().execute(indicator, owner, engine, this.myErrorHandler);
            });
            engine.processRequest(request);
        }
        CompletionStage<Void> completionStage = AbstractDatabaseModifier.wrap(res);
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "scheduleRequests"));
        }
        return completionStage;
    }

    public void runSync() {
        Project project = this.myDataSource.getProject();
        DataSourceUiUtil.performManualSyncTask(this.myContext).whenCompleteAsync((r, e) -> {
            DatabaseView view2 = DatabaseView.getDatabaseView(project);
            view2.selectElements(this.getElement(project));
        }, AsyncUtil.EDT_EXECUTOR);
    }

    @Nullable
    private DbElement getElement(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/AbstractDatabaseModifier", "getElement"));
        }
        DasObject info = AbstractDatabaseModifier.getDasObject(this.myContext.getElementToFocus());
        if (info == null) {
            return null;
        }
        DatabaseElementVirtualFileImpl file = DatabaseElementVirtualFileImpl.findFile(project, (DatabaseSystem)this.myDataSource, ObjectPath.of(info));
        return file == null ? null : file.findElement();
    }

    @Nullable
    private static DasObject getDasObject(@Nullable Object object) {
        return object instanceof DasSchemaChild ? (DasObject)object : (object instanceof DasColumn ? ((DasColumn)object).getTable() : (object instanceof DasTableKey ? ((DasTableKey)object).getTable() : null));
    }

    @NotNull
    protected abstract QueryExecutor getExecutor();

    protected static interface QueryExecutor {
        public Promise<Void> execute(@NotNull ProgressIndicator var1, @NotNull DataRequest.OwnerEx var2, @NotNull DataProducer var3, @NotNull ErrorHandler var4);
    }
}

