/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.FileStructureFilter;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSelectIntoClauseImpl;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStructureViewBuilderProvider
implements PsiStructureViewFactory {
    private static final Condition<PsiElement> DDL_FILTER = Conditions.instanceOf((Class[])new Class[]{SqlDdlStatement.class, SqlDefinition.class});
    private static final Condition<PsiElement> DML_FILTER = Conditions.instanceOf(SqlDmlStatement.class);
    private static final Condition<PsiElement> SELECT_FILTER = Conditions.instanceOf(SqlSelectStatement.class);
    private static final Condition<PsiElement> OTHER_FILTER = Conditions.and((Condition)Conditions.instanceOf(SqlStatement.class), (Condition)Conditions.not((Condition)Conditions.or(DDL_FILTER, (Condition)Conditions.or(DML_FILTER, SELECT_FILTER))));
    private static final int ITEM_TEXT_LENGTH = 50;
    private static final ClassFilter[] FILTERS = new ClassFilter[]{new ClassFilter(DDL_FILTER, "D", new ActionPresentationData("DDL statements", "", DatabaseIcons.SqlDdlStatement)), new ClassFilter(DML_FILTER, "M", new ActionPresentationData("DML statements", "", DatabaseIcons.SqlDmlStatement)), new ClassFilter(SELECT_FILTER, "S", new ActionPresentationData("Select statements", "", DatabaseIcons.SqlSelectStatement)), new ClassFilter(OTHER_FILTER, "O", new ActionPresentationData("Other", "", DatabaseIcons.SqlOtherStatement))};
    private static final Sorter SQL_ALPHA_SORTER = new Sorter(){

        @NotNull
        public Comparator getComparator() {
            Comparator comparator = Sorter.ALPHA_SORTER.getComparator();
            if (comparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$1", "getComparator"));
            }
            return comparator;
        }

        public boolean isVisible() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentation actionPresentation = Sorter.ALPHA_SORTER.getPresentation();
            if (actionPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$1", "getPresentation"));
            }
            return actionPresentation;
        }

        @NotNull
        public String getName() {
            if ("SQL_ALPHA_COMPARATOR" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$1", "getName"));
            }
            return "SQL_ALPHA_COMPARATOR";
        }
    };
    private static final Pattern SPACES = Pattern.compile("\\s+");

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        String propertyName;
        PropertiesComponent properties;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/sql/SqlStructureViewBuilderProvider", "getStructureViewBuilder"));
        }
        if (!(psiFile instanceof SqlFile)) {
            return null;
        }
        if (SqlStructureViewBuilderProvider.noFiltersByDefault() && !(properties = PropertiesComponent.getInstance()).isValueSet(propertyName = TreeStructureUtil.getPropertyName((String)FILTERS[0].getPropertyName()))) {
            properties.setValue(propertyName, "true");
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                MyModel myModel = new MyModel((SqlFile)psiFile, editor);
                if (myModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$2", "createStructureViewModel"));
                }
                return myModel;
            }

            public boolean isRootNodeShown() {
                return false;
            }
        };
    }

    public static boolean noFiltersByDefault() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        for (ClassFilter f : FILTERS) {
            String propertyName = TreeStructureUtil.getPropertyName((String)f.getPropertyName());
            if (!properties.isValueSet(propertyName)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="_,null->null")
    public static String getPresentableName(@Nullable PsiElement element, @Nullable String emptyName) {
        String name = SqlStructureViewBuilderProvider.getPresentableName(element);
        return StringUtil.isEmpty((String)name) ? emptyName : name;
    }

    @Nullable
    private static String getPresentableName(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof SqlSelectStatement) {
            SqlTableExpression fromClause;
            SqlQueryExpression qe = ((SqlSelectStatement)element).getQueryExpression();
            SqlSelectClause selectClause = qe != null ? qe.getSelectClause() : null;
            SqlTableExpression sqlTableExpression = fromClause = qe != null ? qe.getTableExpression() : null;
            if (selectClause != null && fromClause != null) {
                return SqlStructureViewBuilderProvider.trimLong(selectClause.getText(), 25) + " " + SqlStructureViewBuilderProvider.trimLong(fromClause.getText(), 25);
            }
            return SqlStructureViewBuilderProvider.fromText(element);
        }
        if (element instanceof SqlWithClause) {
            return PsiTreeUtil.firstChild((PsiElement)element).getText();
        }
        if (element instanceof DasRoutine) {
            DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element).getDatabaseDialect();
            DdlBuilder builder = new DdlBuilder().applyCodeStyle(element.getProject()).withDialect(dialect);
            if (element instanceof PsiNamedElement) {
                builder.plain(StringUtil.notNullize((String)((PsiNamedElement)element).getName()));
            }
            return dialect.sqlDefinePrototype(builder, (DasRoutine)element, false, true).getStatement();
        }
        if (element instanceof SqlDefinition) {
            String name;
            SqlDefinition definition = (SqlDefinition)element;
            SqlNameElement namedElement = definition.getNameElement();
            if (namedElement == null) {
                if (element instanceof DasConstraint) {
                    String info = DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)((DasConstraint)element).getColumnsRef());
                    if (info.isEmpty()) {
                        SqlDefinition type = (SqlDefinition)PsiTreeUtil.findChildOfType((PsiElement)element, SqlDefinition.class);
                        return SqlStructureViewBuilderProvider.getPresentableName((PsiElement)type);
                    }
                    if (element instanceof DasForeignKey) {
                        DasForeignKey key = (DasForeignKey)element;
                        info = info + DbNodeDescriptor.arrowToColumns(null, key.getRefTableName(), (MultiRef<? extends DasTypedObject>)key.getRefColumns());
                    }
                    return info;
                }
                if (element instanceof DasIndex) {
                    return DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)((DasIndex)element).getColumnsRef());
                }
            }
            if (StringUtil.isEmptyOrSpaces((String)(name = SqlStructureViewBuilderProvider.getPresentableName((PsiElement)namedElement)))) {
                return SqlStructureViewBuilderProvider.fromText(element);
            }
            int offset = namedElement.getTextRange().getEndOffset() - element.getTextRange().getStartOffset();
            return SqlStructureViewBuilderProvider.removeDuplicateSpaces(element.getText().substring(0, offset));
        }
        if (element instanceof SqlNameElement) {
            String s = ((SqlNameElement)element).getName();
            return StringUtil.isEmptyOrSpaces((String)s) ? SqlStructureViewBuilderProvider.fromText(element) : s;
        }
        if (element instanceof DasObject) {
            return ((DasObject)element).getName();
        }
        if (element instanceof SqlBlockStatementImpl) {
            return "begin ... end";
        }
        return SqlStructureViewBuilderProvider.fromText(element);
    }

    @NotNull
    private static String fromText(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlStructureViewBuilderProvider", "fromText"));
        }
        String string = SqlStructureViewBuilderProvider.trimLong(element.getText(), 50);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider", "fromText"));
        }
        return string;
    }

    @NotNull
    private static String trimLong(String text, int limit) {
        if (limit == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider", "trimLong"));
            }
            return "";
        }
        String trim = SqlStructureViewBuilderProvider.removeDuplicateSpaces(text).trim();
        String string = trim.length() > limit ? trim.subSequence(0, (int)((double)limit * 0.9)) + "..." + trim.subSequence((int)((double)trim.length() - (double)limit * 0.1), trim.length()) : trim;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider", "trimLong"));
        }
        return string;
    }

    @NotNull
    private static String removeDuplicateSpaces(@Nullable String text) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider", "removeDuplicateSpaces"));
            }
            return "";
        }
        String string = SPACES.matcher(text).replaceAll(" ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider", "removeDuplicateSpaces"));
        }
        return string;
    }

    private static class TypeGrouper
    implements Grouper {
        private final ActionPresentationData myPresentation;

        public TypeGrouper(ActionPresentationData presentation) {
            this.myPresentation = presentation;
        }

        @NotNull
        public Collection<Group> group(@NotNull AbstractTreeNode parent, @NotNull Collection<TreeElement> children) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper", "group"));
            }
            if (children == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper", "group"));
            }
            Object value = parent.getValue();
            if (!(value instanceof MyElement) || !(((MyElement)((Object)value)).getElement() instanceof PsiFile)) {
                List<Group> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper", "group"));
                }
                return list;
            }
            MultiMap map = new MultiMap();
            for (TreeElement child : children) {
                map.putValue((Object)((MyElement)child).myFilter, (Object)child);
            }
            ArrayList<Group> result2 = new ArrayList<Group>(map.keySet().size());
            for (final ClassFilter filter : FILTERS) {
                final Collection elements = map.get((Object)filter);
                if (elements.isEmpty()) continue;
                result2.add(new Group(){

                    @NotNull
                    public ItemPresentation getPresentation() {
                        PresentationData presentationData = new PresentationData(filter.getName(), "", filter.getPresentation().getIcon(), null);
                        if (presentationData == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper$1", "getPresentation"));
                        }
                        return presentationData;
                    }

                    @NotNull
                    public Collection<TreeElement> getChildren() {
                        Collection collection = elements;
                        if (collection == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper$1", "getChildren"));
                        }
                        return collection;
                    }
                });
            }
            ArrayList<Group> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper", "group"));
            }
            return arrayList;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = this.myPresentation;
            if (actionPresentationData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper", "getPresentation"));
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            String string = this.myPresentation.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper", "getName"));
            }
            return string;
        }
    }

    private static class ClassFilter
    implements FileStructureFilter,
    PropertyOwner {
        private final Condition<PsiElement> myFilter;
        private final Shortcut myShortCut;
        private final String myLetter;
        private final ActionPresentationData myPresentation;

        @NotNull
        public String getPropertyName() {
            String string = "SqlStructureView.filter" + this.myLetter;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$ClassFilter", "getPropertyName"));
            }
            return string;
        }

        ClassFilter(Condition<PsiElement> filter, String shortCutLetter, ActionPresentationData presentation) {
            this.myFilter = filter;
            this.myPresentation = presentation;
            this.myLetter = shortCutLetter;
            this.myShortCut = KeyboardShortcut.fromString((String)((SystemInfo.isMac ? "meta " : "control ") + shortCutLetter));
        }

        public boolean isVisible(TreeElement treeNode) {
            return !(treeNode instanceof MyElement) || !this.acceptsElement(((MyElement)treeNode).getElement());
        }

        protected boolean acceptsElement(PsiElement element) {
            return this.myFilter.value((Object)element);
        }

        public boolean isReverted() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = this.myPresentation;
            if (actionPresentationData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$ClassFilter", "getPresentation"));
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            String string = this.myPresentation.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$ClassFilter", "getName"));
            }
            return string;
        }

        @NotNull
        public String getCheckBoxText() {
            String string = this.myPresentation.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$ClassFilter", "getCheckBoxText"));
            }
            return string;
        }

        @NotNull
        public Shortcut[] getShortcut() {
            Shortcut[] shortcutArray = new Shortcut[]{this.myShortCut};
            if (shortcutArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$ClassFilter", "getShortcut"));
            }
            return shortcutArray;
        }
    }

    private static class MyElement
    extends PsiTreeElementBase<PsiElement>
    implements SortableTreeElement,
    LocationPresentation {
        private final ClassFilter myFilter;
        static final Function<PsiElement, StructureViewTreeElement> TO_ME = element -> new MyElement((PsiElement)element);

        public MyElement(PsiElement element) {
            super(element);
            ClassFilter filter = FILTERS[FILTERS.length - 1];
            for (ClassFilter f : FILTERS) {
                if (!f.acceptsElement(element)) continue;
                filter = f;
                break;
            }
            this.myFilter = filter;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            SqlQueryExpression qe;
            PsiElement element = this.getElement();
            if (element == null) {
                List<StructureViewTreeElement> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$MyElement", "getChildrenBase"));
                }
                return list;
            }
            if (element instanceof SqlColumnDefinition || element instanceof SqlTableKeyDefinition) {
                List<StructureViewTreeElement> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$MyElement", "getChildrenBase"));
                }
                return list;
            }
            if (element instanceof SqlSelectIntoNewTableClauseImpl) {
                List list = JBIterable.from(((SqlSelectIntoNewTableClauseImpl)element).getColumns()).transform(TO_ME).toList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$MyElement", "getChildrenBase"));
                }
                return list;
            }
            if (element instanceof SqlSelectStatement && (qe = ((SqlSelectStatement)element).getQueryExpression()) instanceof SqlWithQueryExpression) {
                List list = JBIterable.of((Object[])new SqlElement[]{((SqlWithQueryExpression)qe).getWithClause(), ((SqlWithQueryExpression)qe).getExpression()}).transform(TO_ME).toList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$MyElement", "getChildrenBase"));
                }
                return list;
            }
            List defs = MyElement.subDefinitions(element).transform(TO_ME).toList();
            if (!defs.isEmpty() || element.getNode() == null) {
                List list = defs;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$MyElement", "getChildrenBase"));
                }
                return list;
            }
            List list = this.subElements(element).flatten(element1 -> {
                if (element1 instanceof SqlBlockStatementImpl && element1.getParent() instanceof SqlDefinition) {
                    return MyElement.subDefinitions((PsiElement)element1).append(this.subElements((PsiElement)element1));
                }
                return JBIterable.of((Object)element1).append(MyElement.subDefinitions((PsiElement)element1));
            }).transform(TO_ME).toList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$MyElement", "getChildrenBase"));
            }
            return list;
        }

        @NotNull
        protected JBIterable<SqlElement> subElements(PsiElement element) {
            JBIterable jBIterable = SqlImplUtil.sqlElements(element).filter(Conditions.notEqualTo((Object)element)).filter(Conditions.instanceOf((Class[])new Class[]{SqlStatement.class, SqlDefinition.class}));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$MyElement", "subElements"));
            }
            return jBIterable;
        }

        private static JBIterable<SqlElement> subDefinitions(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlStructureViewBuilderProvider$MyElement", "subDefinitions"));
            }
            if (!(element instanceof SqlElement)) {
                return JBIterable.empty();
            }
            return SqlImplUtil.getSqlDialectSafe(element).extractDefinitions((SqlElement)element).filter(SqlElement.class);
        }

        @NotNull
        public String getAlphaSortKey() {
            String string = this.getPresentableText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$MyElement", "getAlphaSortKey"));
            }
            return string;
        }

        @NotNull
        public String getPresentableText() {
            PsiElement element = this.getElement();
            String string = SqlStructureViewBuilderProvider.getPresentableName(element, "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$MyElement", "getPresentableText"));
            }
            return string;
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        public String getLocationString() {
            PsiElement element = this.getElement();
            if (element == null) {
                return null;
            }
            return element instanceof DasTypedObject ? ((DasTypedObject)element).getDataType().getSpecification() : null;
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            PsiElement element = this.getElement();
            return element == null ? null : (element instanceof SqlDefinition || element instanceof DasObject ? element.getIcon(0) : this.myFilter.getPresentation().getIcon());
        }

        public String getLocationPrefix() {
            return " ";
        }

        public String getLocationSuffix() {
            return "";
        }
    }

    private static class MyModel
    extends StructureViewModelBase
    implements StructureViewModel.ElementInfoProvider {
        protected MyModel(@NotNull SqlFile psiFile, @Nullable Editor editor) {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/sql/SqlStructureViewBuilderProvider$MyModel", "<init>"));
            }
            super((PsiFile)psiFile, editor, (StructureViewTreeElement)new MyElement((PsiElement)psiFile));
            this.withSuitableClasses(new Class[]{SqlFile.class, SqlDefinition.class, SqlStatement.class, SqlSelectIntoClauseImpl.class});
        }

        public boolean shouldEnterElement(Object element) {
            return false;
        }

        public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
            return false;
        }

        public boolean isAlwaysLeaf(StructureViewTreeElement element) {
            Object e = element.getValue();
            return e instanceof SqlTypedDefinition || e instanceof SqlTableKeyDefinition;
        }

        @NotNull
        public ClassFilter[] getFilters() {
            ClassFilter[] classFilterArray = FILTERS;
            if (classFilterArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$MyModel", "getFilters"));
            }
            return classFilterArray;
        }

        @NotNull
        public Grouper[] getGroupers() {
            Grouper[] grouperArray = new Grouper[]{new TypeGrouper(new ActionPresentationData("Group by type", "", DatabaseIcons.SqlGroupByType))};
            if (grouperArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$MyModel", "getGroupers"));
            }
            return grouperArray;
        }

        public Object getCurrentEditorElement() {
            Object element = super.getCurrentEditorElement();
            if (element != null) {
                return element;
            }
            Editor editor = this.getEditor();
            if (editor == null) {
                return null;
            }
            int offset = editor.getCaretModel().getOffset();
            PsiFile file = this.getPsiFile();
            PsiElement at = file.getViewProvider().findElementAt(offset, file.getLanguage());
            if (at == null && offset > 0) {
                at = file.getViewProvider().findElementAt(offset - 1, file.getLanguage());
            }
            if (at == null) {
                return null;
            }
            Object prev = this.findAcceptableElement(PsiTreeUtil.getPrevSiblingOfType((PsiElement)PsiTreeUtil.prevVisibleLeaf((PsiElement)at), SqlStatement.class));
            if (prev != null) {
                return prev;
            }
            return this.findAcceptableElement(PsiTreeUtil.nextVisibleLeaf((PsiElement)at));
        }

        @NotNull
        public Sorter[] getSorters() {
            Sorter[] sorterArray = new Sorter[]{SQL_ALPHA_SORTER};
            if (sorterArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$MyModel", "getSorters"));
            }
            return sorterArray;
        }
    }
}

