/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mysql.MysqlOptionalKeywords;
import com.intellij.sql.dialects.mysql.MysqlReservedKeywords;
import com.intellij.sql.dialects.mysql.MysqlTokens;
import com.intellij.sql.dialects.mysql.MysqlTypes;
import com.intellij.sql.dialects.mysql.psi.MysqlDelimiterStatementImpl;
import com.intellij.sql.dialects.mysql.psi.MysqlShowStatementImpl;
import com.intellij.sql.dialects.mysql.refactoring.MysqlExtractVariableHelper;
import com.intellij.sql.dialects.sql92.Sql92ReservedKeywords;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlDialect
extends SqlLanguageDialectEx {
    public static final MysqlDialect INSTANCE = new MysqlDialect();

    public MysqlDialect() {
        super("MySQL");
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.MysqlDialect mysqlDialect = com.intellij.database.dialects.MysqlDialect.INSTANCE;
        if (mysqlDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getDatabaseDialect"));
        }
        return mysqlDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map = LazyData.ourFunctionMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getSupportedFunctions"));
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(MysqlTokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getKeywords"));
        }
        return set;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition.Type> getBuiltInTypes() {
        Map<String, SqlFunctionDefinition.Type> map = Types.types;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getBuiltInTypes"));
        }
        return map;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getSystemVariables"));
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        MysqlShowStatementImpl showStatement;
        Pair<IElementType, IElementType> type;
        ReservedEntity.Typed[] cols3;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/mysql/MysqlDialect", "processReservedEntitiesWithType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/mysql/MysqlDialect", "processReservedEntitiesWithType"));
        }
        if (!MysqlDialect.processReservedEntitiesWithTypeDual(name, element, resolve, processor)) {
            return false;
        }
        SqlStatement stmt = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
        if (stmt instanceof MysqlShowStatementImpl && (cols3 = LazyData.RE_SHOW_COLUMNS_BY_TYPE.get(type = (showStatement = (MysqlShowStatementImpl)stmt).getShowType())) != null) {
            for (ReservedEntity.Typed col : cols3) {
                if (MysqlDialect.processReservedEntitiesWithTypeSimple((DasObject)col, col.type, name, element, resolve, processor, true, false)) continue;
                return false;
            }
        }
        return super.processReservedEntitiesWithType(name, element, resolve, processor);
    }

    public boolean isResolveTargetAccepted(@NotNull PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/mysql/MysqlDialect", "isResolveTargetAccepted"));
        }
        if (expectedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedTypes", "com/intellij/sql/dialects/mysql/MysqlDialect", "isResolveTargetAccepted"));
        }
        return element instanceof DasNamespace && expectedTypes.contains(ObjectKind.SCHEMA) || super.isResolveTargetAccepted(element, type, expectedTypes);
    }

    @Override
    @Nullable
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource) {
        DasNamespace namespace = MysqlDialect.getDefaultNamespace(dataSource, null);
        if (namespace != null) {
            return SqlDialectImplUtil.createObjectPattern(dataSource, (DasObject)namespace, null);
        }
        String dbname = SqlDialectImplUtil.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource));
        return new TreePattern(SqlImportUtil.createDataSources(dataSource, SqlImportUtil.createNodeIfNotNull(ObjectName.quoted((String)dbname), ObjectKind.SCHEMA, new TreePatternNode.Group[0])));
    }

    @Override
    public boolean isVariablePrefix(@Nullable String prefix) {
        return "@".equals(prefix) || "@@".equals(prefix);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public boolean isAutoIncrementColumn(@NotNull DasColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/sql/dialects/mysql/MysqlDialect", "isAutoIncrementColumn"));
        }
        if (super.isAutoIncrementColumn(column)) {
            return true;
        }
        String type = column.getDataType().getSpecification();
        return StringUtil.equalsIgnoreCase((CharSequence)type, (CharSequence)"serial");
    }

    @Override
    @NotNull
    public String getDelimiterAt(@NotNull SqlFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/dialects/mysql/MysqlDialect", "getDelimiterAt"));
        }
        String result2 = null;
        if (offset > 0) {
            for (MysqlDelimiterStatementImpl delimiter : SqlImplUtil.iterarateStatementsBackward((PsiFile)file, offset).filter(MysqlDelimiterStatementImpl.class)) {
                if (delimiter.getDelimiter() == null) continue;
                result2 = delimiter.getDelimiter();
                break;
            }
        }
        if (result2 == null) {
            String string = super.getDelimiterAt(file, offset);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getDelimiterAt"));
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getDelimiterAt"));
        }
        return string;
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new MysqlExtractVariableHelper();
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/dialects/mysql/MysqlDialect", "shouldQuotedTypeReferenceBeChecked"));
        }
        return !this.getKeywords().contains(ref);
    }

    @Override
    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/mysql/MysqlDialect", "supportsSql92CharSetSpecFor"));
        }
        return element == SqlCompositeElementTypes.SQL_STRING_LITERAL || element == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || element == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    public boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/mysql/MysqlDialect", "isMajorChild"));
        }
        return kind == ObjectKind.TRIGGER;
    }

    public static class Types {
        public static Map<String, SqlFunctionDefinition.Type> types = ContainerUtil.newMapFromValues(Arrays.asList(new SqlFunctionDefinition.Type("Geometry", "geometric object", null), new SqlFunctionDefinition.Type("JSON", "json", null), new SqlFunctionDefinition.Type("Point", "point", null), new SqlFunctionDefinition.Type("Curve", "curve", null), new SqlFunctionDefinition.Type("LineString", "line string", null), new SqlFunctionDefinition.Type("Line", "line", null), new SqlFunctionDefinition.Type("LinearRing", "linear ring", null), new SqlFunctionDefinition.Type("Surface", "surface", null), new SqlFunctionDefinition.Type("Polygon", "polygon", null), new SqlFunctionDefinition.Type("GeometryCollection", "geometry collection", null), new SqlFunctionDefinition.Type("MultiPoint", "multi point", null), new SqlFunctionDefinition.Type("MultiCurve", "multi curve", null), new SqlFunctionDefinition.Type("MultiLineString", "multi line string", null), new SqlFunctionDefinition.Type("MultiSurface", "multi surface", null), new SqlFunctionDefinition.Type("MultiPolygon", "multi polygon", null)).iterator(), o -> o.getName());
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(MysqlReservedKeywords.class);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.MYSQL_DELIMITER_TOKEN})});
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_INVERT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_NULLSAFE_EQ, SqlElementTypes.SQL_OP_LEFT_SHIFT, SqlElementTypes.SQL_OP_RIGHT_SHIFT, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT2, SqlElementTypes.SQL_OP_ASSIGN, MysqlReservedKeywords.MYSQL_REGEXP, MysqlReservedKeywords.MYSQL_RLIKE, MysqlOptionalKeywords.MYSQL_SOUNDS, MysqlReservedKeywords.MYSQL_DIV, MysqlReservedKeywords.MYSQL_MOD, MysqlReservedKeywords.MYSQL_XOR, MysqlReservedKeywords.MYSQL_BINARY});
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).opt(new IElementType[]{SqlElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlElementTypes.SQL_LOOP, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "end loop", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{SqlElementTypes.SQL_LOOP}).opt(new IElementType[]{SqlElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlElementTypes.SQL_THEN, SqlElementTypes.SQL_THEN_CLAUSE, SqlElementTypes.SQL_IF_STATEMENT}, "", "end if", 2, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{SqlElementTypes.SQL_IF}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlTypes.MYSQL_DO, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "end while", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_WHILE}).opt(new IElementType[]{SqlElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "until  end repeat", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT}).opt(new IElementType[]{SqlElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build())));
        static final Map<Pair<IElementType, IElementType>, ReservedEntity.Typed[]> RE_SHOW_COLUMNS_BY_TYPE = ContainerUtil.immutableMapBuilder().put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_CHARACTER, null), (Object)LazyData.cols(LazyData.col("Charset", (SqlType)SqlType.STRING), LazyData.col("Description", (SqlType)SqlType.STRING), LazyData.col("Default collation", (SqlType)SqlType.STRING), LazyData.col("Maxlen", (SqlType)SqlType.INTEGER))).put(LazyData.type((IElementType)Sql92ReservedKeywords.SQL_COLLATION, null), (Object)LazyData.cols(LazyData.col("Collation", (SqlType)SqlType.STRING), LazyData.col("Charset", (SqlType)SqlType.STRING), LazyData.col("Id", (SqlType)SqlType.INTEGER), LazyData.col("Default", (SqlType)SqlType.STRING), LazyData.col("Compiled", (SqlType)SqlType.STRING), LazyData.col("Sortlen", (SqlType)SqlType.INTEGER))).put(LazyData.type(MysqlTypes.MYSQL_COLUMNS, null), (Object)LazyData.cols(LazyData.col("Field", (SqlType)SqlType.STRING), LazyData.col("Type", (SqlType)SqlType.STRING), LazyData.col("Null", (SqlType)SqlType.STRING), LazyData.col("Default", (SqlType)SqlType.STRING), LazyData.col("Extra", (SqlType)SqlType.STRING))).put(LazyData.type(MysqlTypes.MYSQL_FULL, MysqlTypes.MYSQL_COLUMNS), (Object)LazyData.cols(LazyData.col("Field", (SqlType)SqlType.STRING), LazyData.col("Type", (SqlType)SqlType.STRING), LazyData.col("Collation", (SqlType)SqlType.STRING), LazyData.col("Null", (SqlType)SqlType.STRING), LazyData.col("Key", (SqlType)SqlType.STRING), LazyData.col("Default", (SqlType)SqlType.STRING), LazyData.col("Extra", (SqlType)SqlType.STRING), LazyData.col("Privileges", (SqlType)SqlType.STRING), LazyData.col("Comment", (SqlType)SqlType.STRING))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_DATABASES, null), (Object)LazyData.cols(LazyData.col("database", (SqlType)SqlType.STRING))).put(LazyData.type(MysqlTypes.MYSQL_EVENTS, null), (Object)LazyData.cols(LazyData.col("Db", (SqlType)SqlType.STRING), LazyData.col("Name", (SqlType)SqlType.STRING), LazyData.col("Definer", (SqlType)SqlType.STRING), LazyData.col("Time Zone", (SqlType)SqlType.STRING), LazyData.col("Type", (SqlType)SqlType.STRING), LazyData.col("Execute At", (SqlType)SqlType.DATE_TIME), LazyData.col("Interval Value", (SqlType)SqlType.STRING), LazyData.col("Interval Field", (SqlType)SqlType.STRING), LazyData.col("Starts", (SqlType)SqlType.DATE_TIME), LazyData.col("Ends", (SqlType)SqlType.DATE_TIME), LazyData.col("Status", (SqlType)SqlType.STRING), LazyData.col("Originator", (SqlType)SqlType.STRING), LazyData.col("character_set_client", (SqlType)SqlType.STRING), LazyData.col("collation_connection", (SqlType)SqlType.STRING), LazyData.col("Database Collation", (SqlType)SqlType.STRING))).put(LazyData.type(MysqlTypes.MYSQL_FUNCTION, MysqlTypes.MYSQL_STATUS), (Object)LazyData.cols(LazyData.col("Db", (SqlType)SqlType.STRING), LazyData.col("Name", (SqlType)SqlType.STRING), LazyData.col("Type", (SqlType)SqlType.STRING), LazyData.col("Definer", (SqlType)SqlType.STRING), LazyData.col("Modified", (SqlType)SqlType.DATE_TIME), LazyData.col("Created", (SqlType)SqlType.DATE_TIME), LazyData.col("Security_type", (SqlType)SqlType.STRING), LazyData.col("Comment", (SqlType)SqlType.STRING), LazyData.col("character_set_client", (SqlType)SqlType.STRING), LazyData.col("collation_connection", (SqlType)SqlType.STRING), LazyData.col("Database Collation", (SqlType)SqlType.STRING))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_INDEX, null), (Object)LazyData.cols(LazyData.col("Table", (SqlType)SqlType.STRING), LazyData.col("Non_unique", (SqlType)SqlType.INTEGER), LazyData.col("Key_name", (SqlType)SqlType.STRING), LazyData.col("Seq_in_index", (SqlType)SqlType.INTEGER), LazyData.col("Column_name", (SqlType)SqlType.STRING), LazyData.col("Collation", (SqlType)SqlType.STRING), LazyData.col("Cardinality", (SqlType)SqlType.INTEGER), LazyData.col("Sub_part", (SqlType)SqlType.INTEGER), LazyData.col("Packed", (SqlType)SqlType.STRING), LazyData.col("Null", (SqlType)SqlType.STRING), LazyData.col("Index_type", (SqlType)SqlType.STRING), LazyData.col("Comment", (SqlType)SqlType.STRING), LazyData.col("Index_comment", (SqlType)SqlType.STRING))).put(LazyData.type(MysqlTypes.MYSQL_OPEN, MysqlTypes.MYSQL_TABLES), (Object)LazyData.cols(LazyData.col("Database", (SqlType)SqlType.STRING), LazyData.col("Table", (SqlType)SqlType.STRING), LazyData.col("In_use", (SqlType)SqlType.INTEGER), LazyData.col("Name_locked", (SqlType)SqlType.INTEGER))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_PROCEDURE, MysqlTypes.MYSQL_STATUS), (Object)LazyData.cols(LazyData.col("Db", (SqlType)SqlType.STRING), LazyData.col("Name", (SqlType)SqlType.STRING), LazyData.col("Type", (SqlType)SqlType.STRING), LazyData.col("Definer", (SqlType)SqlType.STRING), LazyData.col("Modified", (SqlType)SqlType.DATE_TIME), LazyData.col("Created", (SqlType)SqlType.DATE_TIME), LazyData.col("Security_type", (SqlType)SqlType.STRING), LazyData.col("Comment", (SqlType)SqlType.STRING), LazyData.col("character_set_client", (SqlType)SqlType.STRING), LazyData.col("collation_connection", (SqlType)SqlType.STRING), LazyData.col("Database Collation", (SqlType)SqlType.STRING))).put(LazyData.type(MysqlTypes.MYSQL_STATUS, null), (Object)LazyData.cols(LazyData.col("Variable_name", (SqlType)SqlType.STRING), LazyData.col("Value", (SqlType)SqlType.INTEGER))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_TABLE, null), (Object)LazyData.cols(LazyData.col("Name", (SqlType)SqlType.STRING), LazyData.col("Engine", (SqlType)SqlType.STRING), LazyData.col("Version", (SqlType)SqlType.INTEGER), LazyData.col("Row_format", (SqlType)SqlType.STRING), LazyData.col("Rows", (SqlType)SqlType.INTEGER), LazyData.col("Avg_row_length", (SqlType)SqlType.INTEGER), LazyData.col("Data_length", (SqlType)SqlType.INTEGER), LazyData.col("Max_data_length", (SqlType)SqlType.INTEGER), LazyData.col("Index_length", (SqlType)SqlType.INTEGER), LazyData.col("Data_free", (SqlType)SqlType.INTEGER), LazyData.col("Auto_increment", (SqlType)SqlType.INTEGER), LazyData.col("Create_time", (SqlType)SqlType.DATE_TIME), LazyData.col("Update_time", (SqlType)SqlType.DATE_TIME), LazyData.col("Check_time", (SqlType)SqlType.DATE_TIME), LazyData.col("Collation", (SqlType)SqlType.STRING), LazyData.col("Checksum", (SqlType)SqlType.INTEGER), LazyData.col("Create_options", (SqlType)SqlType.STRING), LazyData.col("Comment", (SqlType)SqlType.STRING))).put(LazyData.type(MysqlTypes.MYSQL_TRIGGERS, null), (Object)LazyData.cols(LazyData.col("Trigger", (SqlType)SqlType.STRING), LazyData.col("Event", (SqlType)SqlType.STRING), LazyData.col("Table", (SqlType)SqlType.STRING), LazyData.col("Statement", (SqlType)SqlType.STRING), LazyData.col("Timing", (SqlType)SqlType.STRING), LazyData.col("Created", (SqlType)SqlType.DATE_TIME), LazyData.col("sql_mode", (SqlType)SqlType.STRING), LazyData.col("Definer", (SqlType)SqlType.STRING), LazyData.col("character_set_client", (SqlType)SqlType.STRING), LazyData.col("collation_connection", (SqlType)SqlType.STRING), LazyData.col("Database Collation", (SqlType)SqlType.STRING))).put(LazyData.type(MysqlTypes.MYSQL_VARIABLES, null), (Object)LazyData.cols(LazyData.col("Variable_name", (SqlType)SqlType.STRING), LazyData.col("Value", (SqlType)SqlType.STRING))).build();

        private LazyData() {
        }

        private static ReservedEntity.Typed[] cols(ReservedEntity.Typed ... entities) {
            return entities;
        }

        private static ReservedEntity.Typed col(@NotNull String name, @NotNull SqlType type) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/dialects/mysql/MysqlDialect$LazyData", "col"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/dialects/mysql/MysqlDialect$LazyData", "col"));
            }
            return new ReservedEntity.Typed(name, ObjectKind.COLUMN, type);
        }

        private static Pair<IElementType, IElementType> type(IElementType f, IElementType s) {
            return Pair.create((Object)f, (Object)s);
        }
    }
}

