/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.sql.injection.SqlTypeBasedInjection;
import com.intellij.sql.injection.SqlTypeBasedInjector;
import com.intellij.sql.injection.SqlTypePanel;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypeBasedInjectionSupport
extends AbstractLanguageInjectionSupport {
    public static final String SUPPORT_ID = "sql";

    @NotNull
    public String getId() {
        if (SUPPORT_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjectionSupport", "getId"));
        }
        return SUPPORT_ID;
    }

    @NotNull
    public Class[] getPatternClasses() {
        if (ArrayUtil.EMPTY_CLASS_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/injection/SqlTypeBasedInjectionSupport", "getPatternClasses"));
        }
        return ArrayUtil.EMPTY_CLASS_ARRAY;
    }

    public AnAction[] createAddActions(final Project project, final Consumer<BaseInjection> consumer) {
        return new AnAction[]{new AnAction("Sql Type Injection", null, DatabaseIcons.Sql){

            public void actionPerformed(AnActionEvent e) {
                SqlTypeBasedInjection newInjection = SqlTypeBasedInjectionSupport.showInjectionUI(project, new SqlTypeBasedInjection());
                if (newInjection != null) {
                    consumer.consume((Object)newInjection);
                }
            }
        }};
    }

    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        return host instanceof SqlElement;
    }

    public boolean configureInjectionForTypes(@NotNull Project project, @NotNull Language lang, @NotNull Set<String> types) {
        Pattern pattern;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/injection/SqlTypeBasedInjectionSupport", "configureInjectionForTypes"));
        }
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/sql/injection/SqlTypeBasedInjectionSupport", "configureInjectionForTypes"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/sql/injection/SqlTypeBasedInjectionSupport", "configureInjectionForTypes"));
        }
        if (types.isEmpty()) {
            return false;
        }
        SqlTypeBasedInjection injection = new SqlTypeBasedInjection();
        injection.generatePlaces();
        injection.setInjectedLanguageId(lang.getID());
        injection.setPlaceEnabled(null, true);
        String patternStr = StringUtil.join(types, (String)"|");
        try {
            pattern = Pattern.compile(patternStr);
        }
        catch (PatternSyntaxException e) {
            patternStr = StringUtil.join(types, Pattern::quote, (String)"|");
            pattern = Pattern.compile(patternStr);
        }
        injection.setDisplayName(patternStr);
        injection.setPattern(pattern);
        SqlTypeBasedInjection res = SqlTypeBasedInjectionSupport.showInjectionUI(project, injection);
        if (res != null) {
            SqlTypeBasedInjectionSupport.doAddInjection(project, res);
            return true;
        }
        return false;
    }

    public boolean editInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        Project project = psiElement.getProject();
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        SqlTypeBasedInjection injection = SqlTypeBasedInjectionSupport.findUsedInjection(psiElement);
        if (injection == null) {
            return false;
        }
        SqlTypeBasedInjection result2 = SqlTypeBasedInjectionSupport.showInjectionUI(project, injection.copy());
        if (result2 != null) {
            configuration.replaceInjectionsWithUndo(project, Collections.singletonList(result2), Collections.singletonList(injection), Collections.emptyList());
        }
        return true;
    }

    @Nullable
    private static SqlTypeBasedInjection findUsedInjection(PsiLanguageInjectionHost psiElement) {
        if (SqlTypeBasedInjector.isInjectedByComment(psiElement)) {
            return null;
        }
        Set<String> types = SqlTypeBasedInjector.getTypesFor(psiElement);
        if (types.isEmpty() || types.size() > 1) {
            return null;
        }
        String type = types.iterator().next();
        Project project = psiElement.getProject();
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        return (SqlTypeBasedInjection)((Object)JBIterable.from((Iterable)configuration.getInjections(SUPPORT_ID)).filter(SqlTypeBasedInjection.class).filter(i2 -> i2.getPattern().matcher(type).matches()).first());
    }

    public boolean removeInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        Project project = psiElement.getProject();
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        SqlTypeBasedInjection injection = SqlTypeBasedInjectionSupport.findUsedInjection(psiElement);
        if (injection == null) {
            return false;
        }
        configuration.replaceInjectionsWithUndo(project, Collections.emptyList(), Collections.singletonList(injection), Collections.emptyList());
        return true;
    }

    public BaseInjection createInjection(Element element) {
        return new SqlTypeBasedInjection();
    }

    public AnAction createEditAction(final Project project, final Factory<BaseInjection> producer) {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                SqlTypeBasedInjection newInjection = SqlTypeBasedInjectionSupport.showInjectionUI(project, (SqlTypeBasedInjection)((BaseInjection)producer.create()).copy());
                if (newInjection != null) {
                    ((BaseInjection)producer.create()).copyFrom((BaseInjection)newInjection);
                }
            }
        };
    }

    @Nullable
    private static SqlTypeBasedInjection showInjectionUI(Project project, SqlTypeBasedInjection injection) {
        DialogBuilder builder = new DialogBuilder(project);
        SqlTypePanel panel = new SqlTypePanel(injection, project);
        builder.setHelpId("reference.settings.injection.language.injection.settings.sql.type");
        panel.reset();
        builder.addOkAction();
        builder.addCancelAction();
        builder.setCenterPanel((JComponent)panel.getComponent());
        builder.setTitle("Language Injection Settings");
        builder.setOkOperation(() -> {
            panel.apply();
            builder.getDialogWrapper().close(0);
        });
        builder.setDimensionServiceKey(SqlTypeBasedInjectionSupport.class.getName());
        if (builder.show() == 0) {
            return injection.copy();
        }
        return null;
    }

    private static void doAddInjection(Project project, SqlTypeBasedInjection template) {
        Configuration configuration = InjectorUtils.getEditableInstance((Project)project);
        SqlTypeBasedInjection originalInjection = (SqlTypeBasedInjection)configuration.findExistingInjection((BaseInjection)template);
        SqlTypeBasedInjection newInjection = originalInjection == null || !originalInjection.equals((Object)template) ? template : originalInjection.copy();
        configuration.replaceInjectionsWithUndo(project, Collections.singletonList(newInjection), Collections.emptyList(), Collections.emptyList());
    }
}

