/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlReferenceExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlIdentifierInspection
extends SqlInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = SqlMessages.message("inspection.name.identifier", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlIdentifierInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean isOnTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlIdentifierInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlIdentifierInspection", "createAnnotationVisitor"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/inspections/SqlIdentifierInspection", "createAnnotationVisitor"));
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlReferenceExpression(SqlReferenceExpression o) {
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (o.resolve() == o) {
                    return;
                }
                super.visitSqlReferenceExpression(o);
            }

            public void visitSqlFunctionCallExpression(SqlFunctionCallExpression o) {
            }

            public void visitSqlIdentifier(SqlIdentifier o) {
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (!o.isPlainIdentifier()) {
                    return;
                }
                if (o.getParent() instanceof SqlParameter) {
                    return;
                }
                ProblemDescriptor problemDescriptor = this.myDialect.checkIdentifierText(o, this.myManager, isOnTheFly);
                if (problemDescriptor != null) {
                    this.addDescriptor(problemDescriptor);
                }
            }
        };
    }
}

