/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlNAryExpressionImpl
extends SqlExpressionImpl
implements SqlNAryExpression {
    public SqlNAryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlExpression((SqlExpression)this);
    }

    @NotNull
    public List<SqlExpression> getOperands() {
        List list = SqlImplUtil.childrenIt((PsiElement)this).filter(SqlExpression.class).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getOperands"));
        }
        return list;
    }

    @Nullable
    public PsiElement getOpSignElement(int i2) {
        SqlExpression op = null;
        if (i2 != 0) {
            List<SqlExpression> operands = this.getOperands();
            if (i2 < operands.size()) {
                op = operands.get(i2);
            }
        } else {
            op = this.getLOperand();
        }
        return SqlNAryExpressionImpl.getOpAfter((PsiElement)op);
    }

    @NotNull
    public SqlExpression getLOperand() {
        SqlExpression sqlExpression = (SqlExpression)this.findNotNullChildByClass(SqlExpression.class);
        if (sqlExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getLOperand"));
        }
        return sqlExpression;
    }

    @NotNull
    public IElementType getOpSign() {
        PsiElement signElement = this.getOpSignElement();
        ASTNode astNode = signElement.getNode();
        assert (astNode != null);
        IElementType iElementType = astNode.getElementType();
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getOpSign"));
        }
        return iElementType;
    }

    @NotNull
    public PsiElement getOpSignElement() {
        PsiElement node = SqlNAryExpressionImpl.getOpAfter((PsiElement)this.getLOperand());
        if (node != null) {
            PsiElement psiElement = node;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getOpSignElement"));
            }
            return psiElement;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{SqlStatement.class, PsiFile.class});
        throw new AssertionError((Object)((Object)((Object)SqlImplUtil.getSqlDialectSafe((PsiElement)this)) + ": parent='" + (parent == null ? this : this.getParent()).getText() + "'"));
    }

    @Nullable
    private static PsiElement getOpAfter(@Nullable PsiElement el) {
        if (el == null) {
            return null;
        }
        for (ASTNode node = el.getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            IElementType type = node.getElementType();
            if (type == TokenType.WHITE_SPACE || SqlTokens.COMMENT_TOKENS.contains(type)) continue;
            if (type instanceof SqlTokenType) {
                return node.getPsi();
            }
            if (type == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE) {
                return node.getPsi();
            }
            if (type instanceof SqlCompositeElementType) break;
        }
        return null;
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlType lType = this.getLOperand().getSqlType();
        IElementType sign = this.getOpSign();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        DatabaseFamilyId familyId = dialect.getFamilyId();
        if (sign == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE) {
            PsiElement nameToken;
            SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getOpSignElement(), SqlReferenceExpression.class);
            SqlIdentifier identifier = ref == null ? null : ref.getIdentifier();
            PsiElement psiElement = nameToken = identifier == null ? null : PsiTreeUtil.getDeepestFirst((PsiElement)identifier);
            if (nameToken != null) {
                sign = PsiUtilCore.getElementType((PsiElement)nameToken);
            }
        }
        if (sign == SqlTokens.SQL_OP_EQ || sign == SqlTokens.SQL_OP_NEQ || sign == SqlTokens.SQL_OP_GT || sign == SqlTokens.SQL_OP_LT || sign == SqlTokens.SQL_OP_GE || sign == SqlTokens.SQL_OP_LE || sign == SqlTokens.SQL_OP_LOGICAL_AND || sign == SqlTokens.SQL_OP_NULLSAFE_EQ || sign == SqlTokens.SQL_OP_LOGICAL_OR && (familyId.isTransactSql() || familyId.isMysql()) || sign == SqlTokens.SQL_OP_NEQ2 || sign == SqlTokens.SQL_OP_NEQ3 || sign == SqlTokens.SQL_OP_NEQ_WS || sign == SqlTokens.SQL_OP_NEQ2_WS || sign == SqlTokens.SQL_OP_NEQ3_WS || sign == SqlTokens.SQL_LIKE || sign == SqlTokens.SQL_IS) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.BOOLEAN;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (sign == SqlTokens.SQL_OP_PLUS || sign == SqlTokens.SQL_OP_MINUS || sign == SqlTokens.SQL_OP_MUL || sign == SqlTokens.SQL_OP_DIV) {
            if (lType == SqlType.REAL) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.REAL;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getSqlType"));
                }
                return sqlPrimitiveType;
            }
            if (lType == SqlType.DATE) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.DATE;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getSqlType"));
                }
                return sqlPrimitiveType;
            }
            if (lType == SqlType.TIME) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.TIME;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getSqlType"));
                }
                return sqlPrimitiveType;
            }
            if (lType == SqlType.TIMESTAMP) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.TIMESTAMP;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getSqlType"));
                }
                return sqlPrimitiveType;
            }
            if (lType == SqlType.DATE_TIME) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.DATE_TIME;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getSqlType"));
                }
                return sqlPrimitiveType;
            }
            SqlPrimitiveType sqlPrimitiveType = SqlType.INTEGER;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (sign == SqlTokens.SQL_OP_BITWISE_XOR || sign == SqlTokens.SQL_OP_BITWISE_AND || sign == SqlTokens.SQL_OP_BITWISE_OR || sign == SqlTokens.SQL_OP_INVERT || sign == SqlTokens.SQL_OP_LEFT_SHIFT || sign == SqlTokens.SQL_OP_RIGHT_SHIFT || sign == SqlTokens.SQL_OP_MODULO) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.INTEGER;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (sign == SqlTokens.SQL_OP_CONCAT) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.STRING;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlNAryExpressionImpl", "getSqlType"));
        }
        return sqlPrimitiveType;
    }
}

