/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlParameterList;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.stubs.SqlDefinitionStubElementType;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlProcedureDefinitionImpl
extends SqlStubbedDefinitionImpl<SqlNamedElementStub<?>>
implements DasRoutine {
    public SqlProcedureDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlProcedureDefinitionImpl", "<init>"));
        }
        super(node);
    }

    public SqlProcedureDefinitionImpl(SqlNamedElementStub<?> stub) {
        super(stub, SqlCompositeElementTypes.SQL_PROCEDURE_DEFINITION);
    }

    protected SqlProcedureDefinitionImpl(SqlNamedElementStub<?> stub, SqlDefinitionStubElementType type) {
        super(stub, type);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlElementTypes.SQL_PROCEDURE_REFERENCE;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROUTINE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlProcedureDefinitionImpl", "getKind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/psi/impl/SqlProcedureDefinitionImpl", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlProcedureDefinitionImpl", "getDbChildren"));
        }
        if (kind != ObjectKind.NONE && kind != ObjectKind.ARGUMENT) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlProcedureDefinitionImpl", "getDbChildren"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)this.getReturnArgument()).append(this.getArguments()).filter(clazz);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlProcedureDefinitionImpl", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlDefinition((SqlDefinition)this);
    }

    @NotNull
    public Iterable<SqlParameterDefinition> getArguments() {
        SqlNamedElementStub stub = (SqlNamedElementStub)this.getStub();
        if (stub != null) {
            JBIterable jBIterable = JBIterable.of((Object[])stub.getChildrenByType((IElementType)SqlCompositeElementTypes.SQL_PARAMETER_DEFINITION, SqlTypedDefinition.ARRAY_FACTORY)).filter(SqlParameterDefinition.class);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlProcedureDefinitionImpl", "getArguments"));
            }
            return jBIterable;
        }
        SqlParameterList list = (SqlParameterList)PsiTreeUtil.getChildOfType((PsiElement)this, SqlParameterList.class);
        if (list == null) {
            Iterable iterable = ContainerUtil.emptyIterable();
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlProcedureDefinitionImpl", "getArguments"));
            }
            return iterable;
        }
        List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)list, SqlParameterDefinition.class);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlProcedureDefinitionImpl", "getArguments"));
        }
        return list2;
    }

    @Nullable
    public DasArgument getReturnArgument() {
        if (this.getRoutineKind() != DasRoutine.Kind.FUNCTION) {
            return null;
        }
        return (DasArgument)this.getStubOrPsiChild(SqlCompositeElementTypes.SQL_RETURNS_CLAUSE);
    }

    public String getPackageName() {
        DasObject definition = this.getDbParent();
        return definition != null && definition.getKind() == ObjectKind.PACKAGE ? definition.getName() : null;
    }

    @NotNull
    public DasRoutine.Kind getRoutineKind() {
        DasRoutine.Kind kind = DasRoutine.Kind.PROCEDURE;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlProcedureDefinitionImpl", "getRoutineKind"));
        }
        return kind;
    }
}

