/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTableColumnsListImpl
extends SqlCompositeElementImpl
implements SqlTableColumnsList {
    public SqlTableColumnsListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlTableColumnsListImpl", "<init>"));
        }
        super(node);
    }

    public SqlReferenceExpression getTableReference() {
        return (SqlReferenceExpression)this.findChildByClass(SqlReferenceExpression.class);
    }

    @Nullable
    public SqlExpression getTableExpression() {
        return (SqlExpression)this.findChildByClass(SqlExpression.class);
    }

    public SqlReferenceList getColumnsReferenceList() {
        return (SqlReferenceList)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_REFERENCE_LIST);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlTableColumnList((SqlTableColumnsList)this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlTableColumnsListImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlTableColumnsListImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlTableColumnsListImpl", "processDeclarations"));
        }
        if (lastParent != null && lastParent.getParent() == this) {
            return this.processImplicitContextDeclarations(processor, state, lastParent, place);
        }
        return true;
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlExpression tableExpression = this.getTableExpression();
        if (lastParent != tableExpression) {
            SqlCreateTableStatement createTable;
            if (tableExpression instanceof SqlReferenceExpression) {
                if (!SqlImplUtil.processQualifier((SqlReferenceExpression)tableExpression, processor, state, place)) {
                    return false;
                }
                for (ResolveResult resolve : ((SqlReferenceExpression)tableExpression).multiResolve(false)) {
                    if (SqlImplUtil.processObjectParents(resolve.getElement(), processor, state)) continue;
                    return false;
                }
            } else {
                SqlType type;
                if (tableExpression instanceof PsiNamedElement && !processor.execute((PsiElement)tableExpression, state)) {
                    return false;
                }
                SqlType sqlType = type = tableExpression == null ? null : tableExpression.getSqlType();
                if (type instanceof SqlTableType) {
                    SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, state);
                }
            }
            if ((createTable = (SqlCreateTableStatement)PsiTreeUtil.getParentOfType((PsiElement)this, SqlCreateTableStatement.class)) != null) {
                return createTable.processDeclarations(processor, state, lastParent, place);
            }
            SqlScopeProcessor sqlScopeProcessor = (SqlScopeProcessor)((Object)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class));
            Set<Object> expected = sqlScopeProcessor == null ? Collections.emptySet() : sqlScopeProcessor.getExpectedTypes();
            return expected.contains(SqlDbElementType.ANY) || expected.contains(ObjectKind.ROUTINE);
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    @NotNull
    public SqlType getSqlType() {
        SqlExpression tableExpression = this.getTableExpression();
        SqlPrimitiveType type = tableExpression == null ? SqlType.UNKNOWN : tableExpression.getSqlType();
        List<SqlReferenceExpression> referenceList = SqlImplUtil.getReferenceList(this);
        if (referenceList.isEmpty()) {
            SqlPrimitiveType sqlPrimitiveType = type;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTableColumnsListImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        SqlTableType sqlTableType = (type instanceof SqlTableType ? (SqlTableType)type : SqlTableTypeBase.EMPTY_TABLE).alias(tableExpression == null ? null : tableExpression.getText(), (PsiElement)this, referenceList);
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTableColumnsListImpl", "getSqlType"));
        }
        return sqlTableType;
    }
}

