/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.view.FeaturesPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;

public final class AssistSidePanel
extends JPanel {
    public AssistSidePanel(@NotNull String actionId, @NotNull Project project) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/android/tools/idea/assistant/AssistSidePanel", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/assistant/AssistSidePanel", "<init>"));
        }
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        FeaturesPanel assistContents = null;
        for (AssistantBundleCreator creator : (AssistantBundleCreator[])AssistantBundleCreator.EP_NAME.getExtensions()) {
            if (!creator.getBundleId().equals(actionId)) continue;
            URL config = null;
            try {
                config = creator.getConfig();
            }
            catch (FileNotFoundException e) {
                AssistSidePanel.getLog().warn((Throwable)e);
            }
            TutorialBundleData bundle = config != null ? AssistSidePanel.getBundle(config) : creator.getBundle(project);
            if (bundle == null) {
                AssistSidePanel.getLog().error("Unable to get Assistant configuration for action: " + actionId);
                return;
            }
            bundle.setResourceClass(creator.getClass());
            for (FeatureData featureData : bundle.getFeatures()) {
                featureData.setResourceClass(creator.getClass());
            }
            AnalyticsProvider analyticsProvider = creator.getAnalyticsProvider();
            analyticsProvider.trackPanelOpened(project);
            assistContents = new FeaturesPanel(bundle, project, analyticsProvider);
            break;
        }
        if (assistContents == null) {
            throw new RuntimeException("Unable to find configuration for the selected action: " + actionId);
        }
        this.add(assistContents);
    }

    private static Logger getLog() {
        return Logger.getInstance(AssistSidePanel.class);
    }

    private static TutorialBundleData getBundle(@NotNull URL config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/android/tools/idea/assistant/AssistSidePanel", "getBundle"));
        }
        InputStream inputStream = null;
        TutorialBundleData bundle = null;
        try {
            inputStream = config.openStream();
            bundle = DefaultTutorialBundle.parse(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse " + config.toString() + " to read services configuration.", e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                AssistSidePanel.getLog().warn((Throwable)e);
            }
        }
        return bundle;
    }
}

