/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.error;

import com.android.tools.idea.diagnostics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.CrashReporter;
import com.android.tools.idea.diagnostics.error.ErrorReportCustomizer;
import com.android.tools.idea.diagnostics.error.SubmitCrashReportTask;
import com.google.common.collect.Maps;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.idea.IdeaLogger;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.diagnostics.error.IdeaITNProxy;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ErrorReporter
extends ErrorReportSubmitter {
    private static final String FEEDBACK_TASK_TITLE = "Submitting error report";

    public String getReportActionText() {
        return AndroidBundle.message("error.report.to.google.action", new Object[0]);
    }

    public boolean submit(@NotNull IdeaLoggingEvent[] events, String description, Component parentComponent, @NotNull Consumer<SubmittedReportInfo> callback) {
        Task.Backgroundable feedbackTask;
        Object data;
        IdeaPluginDescriptor ideaPluginDescriptor;
        PluginId pluginId;
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/diagnostics/error/ErrorReporter", "submit"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/diagnostics/error/ErrorReporter", "submit"));
        }
        IdeaLoggingEvent event = events[0];
        ErrorBean bean = new ErrorBean(event.getThrowable(), IdeaLogger.ourLastActionId);
        DataContext dataContext = DataManager.getInstance().getDataContext(parentComponent);
        bean.setDescription(description);
        bean.setMessage(event.getMessage());
        Throwable t = event.getThrowable();
        if (t != null && (pluginId = IdeErrorsDialog.findPluginId((Throwable)t)) != null && (ideaPluginDescriptor = PluginManager.getPlugin((PluginId)pluginId)) != null && (!ideaPluginDescriptor.isBundled() || ideaPluginDescriptor.allowBundledUpdate())) {
            bean.setPluginName(ideaPluginDescriptor.getName());
            bean.setPluginVersion(ideaPluginDescriptor.getVersion());
        }
        if (ErrorReporter.handleAnalyticsReports(t, data = event.getData())) {
            return true;
        }
        if (data instanceof AbstractMessage) {
            bean.setAttachments(((AbstractMessage)data).getIncludedAttachments());
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Consumer successCallback = token -> {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/diagnostics/error/ErrorReporter", "lambda$submit$0"));
            }
            SubmittedReportInfo reportInfo = new SubmittedReportInfo(null, "Issue " + token, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
            callback.consume((Object)reportInfo);
            ReportMessages.GROUP.createNotification(ReportMessages.ERROR_REPORT, "Submitted", NotificationType.INFORMATION, null).setImportant(false).notify(project);
        };
        Consumer errorCallback = e -> {
            String message = AndroidBundle.message("error.report.at.b.android", e.getMessage());
            ReportMessages.GROUP.createNotification(ReportMessages.ERROR_REPORT, message, NotificationType.ERROR, NotificationListener.URL_OPENING_LISTENER).setImportant(false).notify(project);
        };
        if (data instanceof ErrorReportCustomizer) {
            feedbackTask = ((ErrorReportCustomizer)data).makeReportingTask(project, FEEDBACK_TASK_TITLE, true, bean, (Consumer<String>)successCallback, (Consumer<Exception>)errorCallback);
        } else {
            List<Pair<String, String>> kv = IdeaITNProxy.getKeyValuePairs(null, null, bean, IdeaLogger.getOurCompilationTimestamp(), ApplicationManager.getApplication(), (ApplicationInfoEx)ApplicationInfo.getInstance(), ApplicationNamesInfo.getInstance(), UpdateSettings.getInstance());
            feedbackTask = new SubmitCrashReportTask(project, FEEDBACK_TASK_TITLE, true, t, ErrorReporter.pair2map(kv), (Consumer<String>)successCallback, (Consumer<Exception>)errorCallback);
        }
        if (project == null) {
            feedbackTask.run((ProgressIndicator)new EmptyProgressIndicator());
        } else {
            ProgressManager.getInstance().run((Task)feedbackTask);
        }
        return true;
    }

    private static boolean handleAnalyticsReports(Throwable t, Object data) {
        if ("Exception".equals(data)) {
            if (t != null) {
                CrashReporter.getInstance().submit(CrashReport.Builder.createForException(t).build());
            }
            return true;
        }
        if (data instanceof Map) {
            Map map = (Map)data;
            String type = (String)map.get("Type");
            if ("ANR".equals(type)) {
                CrashReporter.getInstance().submit(CrashReport.Builder.createForPerfReport((String)map.get("file"), (String)map.get("threadDump")).build());
            } else if ("Crashes".equals(type)) {
                List descriptions = (List)map.get("descriptions");
                CrashReporter.getInstance().submit(CrashReport.Builder.createForCrashes(descriptions).build());
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static Map<String, String> pair2map(@NotNull List<Pair<String, String>> kv) {
        if (kv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kv", "com/android/tools/idea/diagnostics/error/ErrorReporter", "pair2map"));
        }
        HashMap m = Maps.newHashMapWithExpectedSize((int)kv.size());
        for (Pair<String, String> i : kv) {
            m.put(i.getFirst(), i.getSecond());
        }
        HashMap hashMap = m;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/diagnostics/error/ErrorReporter", "pair2map"));
        }
        return hashMap;
    }
}

