/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.resources.ResourceType;
import com.android.tools.idea.model.MergedManifest;
import com.intellij.codeInsight.ImportFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidImportFilter
extends ImportFilter {
    public boolean shouldUseFullyQualifiedName(@NotNull PsiFile targetFile, @NotNull String classQualifiedName) {
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/android/tools/idea/editors/AndroidImportFilter", "shouldUseFullyQualifiedName"));
        }
        if (classQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classQualifiedName", "com/android/tools/idea/editors/AndroidImportFilter", "shouldUseFullyQualifiedName"));
        }
        if (classQualifiedName.equals("android.R") || classQualifiedName.startsWith("android.R.") || classQualifiedName.equals("android.databinding.tool.util.GenerationalClassUtil.ExtensionFilter.BR")) {
            return true;
        }
        int index = classQualifiedName.lastIndexOf(46);
        if (index == classQualifiedName.length() - 2 && classQualifiedName.charAt(index + 1) == 'R') {
            String pkg = AndroidImportFilter.getApplicationPackage(targetFile);
            if (pkg != null) {
                return !AndroidImportFilter.isResourceClassReference(classQualifiedName, pkg + ".R");
            }
        } else if (index > 2 && classQualifiedName.charAt(index - 1) == 'R' && classQualifiedName.charAt(index - 2) == '.') {
            return classQualifiedName.startsWith("android.R") || ResourceType.getEnum((String)classQualifiedName.substring(index + 1)) != null;
        }
        return false;
    }

    @Nullable
    private static String getApplicationPackage(@NotNull PsiFile targetFile) {
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/android/tools/idea/editors/AndroidImportFilter", "getApplicationPackage"));
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)targetFile);
        if (facet != null) {
            return MergedManifest.get(facet).getPackage();
        }
        return null;
    }

    private static boolean isResourceClassReference(String reference, String resourceClass) {
        return reference.equals(resourceClass) || reference.startsWith(resourceClass + ".");
    }
}

