/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hierarchyview;

import com.android.tools.idea.editors.hierarchyview.HierarchyViewCaptureOptions;
import com.android.tools.idea.editors.hierarchyview.HierarchyViewer;
import com.android.tools.idea.editors.hierarchyview.model.ViewNode;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchyViewEditor
extends UserDataHolderBase
implements FileEditor {
    private final VirtualFile myVirtualFile;
    private HierarchyViewer myViewer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HierarchyViewEditor(@NotNull Project project, @NotNull VirtualFile file) throws IOException {
        byte[] previewBytes;
        ViewNode node;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/hierarchyview/HierarchyViewEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/hierarchyview/HierarchyViewEditor", "<init>"));
        }
        this.myVirtualFile = file;
        try (ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(file.contentsToByteArray()));){
            HierarchyViewCaptureOptions options = new HierarchyViewCaptureOptions();
            options.parse(input.readUTF());
            byte[] nodeBytes = new byte[input.readInt()];
            input.readFully(nodeBytes);
            node = ViewNode.parseFlatString(nodeBytes);
            if (node == null) {
                throw new IOException("Error parsing view node");
            }
            previewBytes = new byte[input.readInt()];
            input.readFully(previewBytes);
        }
        BufferedImage preview = ImageIO.read(new ByteArrayInputStream(previewBytes));
        this.myViewer = new HierarchyViewer(node, preview, PropertiesComponent.getInstance((Project)project), (Disposable)this);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myViewer.getRootComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hierarchyview/HierarchyViewEditor", "getComponent"));
        }
        return jComponent;
    }

    public void dispose() {
        this.myViewer = null;
    }

    @NotNull
    public String getName() {
        if ("Hierarchy Viewer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hierarchyview/HierarchyViewEditor", "getName"));
        }
        return "Hierarchy Viewer";
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/hierarchyview/HierarchyViewEditor", "setState"));
        }
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/hierarchyview/HierarchyViewEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/hierarchyview/HierarchyViewEditor", "removePropertyChangeListener"));
        }
    }

    public void deselectNotify() {
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void selectNotify() {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public boolean isModified() {
        return false;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public boolean isValid() {
        return this.myVirtualFile.isValid();
    }
}

