/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.builder.model.SourceProvider;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.android.tools.idea.editors.theme.MaterialColorUtils;
import com.android.tools.idea.editors.theme.NewStyleDialog;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditor;
import com.android.tools.idea.editors.theme.ThemeEditorComponent;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.util.Processor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorUtils {
    private static final Logger LOG = Logger.getInstance(ThemeEditorUtils.class);
    private static final Cache<String, String> ourTooltipCache = CacheBuilder.newBuilder().weakValues().maximumSize(30L).build();
    private static final Set<String> DEFAULT_THEMES = ImmutableSet.of((Object)"Theme.AppCompat.NoActionBar", (Object)"Theme.AppCompat.Light.NoActionBar");
    private static final Set<String> DEFAULT_THEMES_FALLBACK = ImmutableSet.of((Object)"Theme.Material.NoActionBar", (Object)"Theme.Material.Light.NoActionBar");
    private static final String[] CUSTOM_WIDGETS_JAR_PATHS = new String[]{"/plugins/android/lib/androidWidgets/theme-editor-widgets.jar", "/../adt/idea/android/lib/androidWidgets/theme-editor-widgets.jar", "/community/android/android/lib/androidWidgets/theme-editor-widgets.jar", "/android/android/lib/androidWidgets/theme-editor-widgets.jar"};

    private ThemeEditorUtils() {
    }

    @NotNull
    public static String generateToolTipText(@NotNull ItemResourceValue resValue, @NotNull Module module, @NotNull Configuration configuration) {
        if (resValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resValue", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
        }
        AppResourceRepository repository = AppResourceRepository.getAppResources(module, true);
        if (repository == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
            }
            return "";
        }
        String tooltipKey = resValue.toString() + module.toString() + configuration.toString() + ((LocalResourceRepository)repository).getModificationCount();
        String cachedTooltip = (String)ourTooltipCache.getIfPresent((Object)tooltipKey);
        if (cachedTooltip != null) {
            String string = cachedTooltip;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
            }
            return string;
        }
        ResourceUrl url = ResourceUrl.parse((String)ResolutionUtils.getResourceUrlFromQualifiedName(ResolutionUtils.getQualifiedItemName(resValue), "attr"));
        assert (url != null);
        String tooltipContents = AndroidJavaDocRenderer.render(module, configuration, url);
        assert (tooltipContents != null);
        ourTooltipCache.put((Object)tooltipKey, (Object)tooltipContents);
        String string = tooltipContents;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
        }
        return string;
    }

    @NotNull
    public static String getDisplayHtml(EditedStyleItem item) {
        String string = item.isDeprecated() ? "<html><body><strike>" + item.getQualifiedName() + "</strike></body></html>" : item.getQualifiedName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDisplayHtml"));
        }
        return string;
    }

    public static boolean isThemeEditorSelected(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "isThemeEditorSelected"));
        }
        for (FileEditor editor : FileEditorManager.getInstance((Project)project).getSelectedEditors()) {
            if (!(editor instanceof ThemeEditor)) continue;
            return true;
        }
        return false;
    }

    public static void openThemeEditor(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "openThemeEditor"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ThemeEditorVirtualFile file = ThemeEditorVirtualFile.getThemeEditorFile(project);
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
                FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
            }
        });
    }

    @Nullable
    public static ItemResourceValue resolveItemFromParents(@NotNull ConfiguredThemeEditorStyle theme, @NotNull String name, boolean isFrameworkAttr) {
        if (theme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theme", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "resolveItemFromParents"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "resolveItemFromParents"));
        }
        ConfiguredThemeEditorStyle currentTheme = theme;
        for (int i = 0; i < 50 && currentTheme != null; currentTheme = currentTheme.getParent(), ++i) {
            ItemResourceValue item = currentTheme.getItem(name, isFrameworkAttr);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @Nullable
    public static Object extractRealValue(@NotNull EditedStyleItem item, @NotNull Class<?> desiredClass) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "extractRealValue"));
        }
        if (desiredClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desiredClass", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "extractRealValue"));
        }
        String value = item.getValue();
        if (desiredClass == Boolean.class && ("true".equals(value) || "false".equals(value))) {
            return Boolean.valueOf(value);
        }
        if (desiredClass == Integer.class) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        return value;
    }

    public static boolean acceptsFormat(@Nullable AttributeDefinition attrDefByName, @NotNull AttributeFormat want) {
        if (want == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "want", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "acceptsFormat"));
        }
        if (attrDefByName == null) {
            return false;
        }
        return attrDefByName.getFormats().contains((Object)want);
    }

    @NotNull
    private static ImmutableCollection<ConfiguredThemeEditorStyle> findThemes(@NotNull Collection<ConfiguredThemeEditorStyle> themes, final @NotNull Set<String> names) {
        if (themes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themes", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findThemes"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findThemes"));
        }
        ImmutableSet immutableSet = ImmutableSet.copyOf((Iterable)Iterables.filter(themes, (Predicate)new Predicate<ConfiguredThemeEditorStyle>(){

            public boolean apply(@Nullable ConfiguredThemeEditorStyle theme) {
                return theme != null && names.contains(theme.getName());
            }
        }));
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findThemes"));
        }
        return immutableSet;
    }

    @NotNull
    public static ImmutableList<Module> findAndroidModules(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findAndroidModules"));
        }
        ModuleManager manager = ModuleManager.getInstance((Project)project);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Module module : manager.getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            builder.add((Object)module);
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findAndroidModules"));
        }
        return immutableList;
    }

    @NotNull
    public static ImmutableList<String> getDefaultThemeNames(@NotNull ThemeResolver themeResolver) {
        if (themeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeResolver", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultThemeNames"));
        }
        ImmutableList<ConfiguredThemeEditorStyle> readOnlyLibThemes = themeResolver.getExternalLibraryThemes();
        HashSet<ConfiguredThemeEditorStyle> foundThemes = new HashSet<ConfiguredThemeEditorStyle>();
        foundThemes.addAll((Collection<ConfiguredThemeEditorStyle>)ThemeEditorUtils.findThemes(readOnlyLibThemes, DEFAULT_THEMES));
        if (foundThemes.isEmpty()) {
            ImmutableList<ConfiguredThemeEditorStyle> readOnlyFrameworkThemes = themeResolver.getFrameworkThemes();
            foundThemes = new HashSet();
            foundThemes.addAll((Collection<ConfiguredThemeEditorStyle>)ThemeEditorUtils.findThemes(readOnlyFrameworkThemes, DEFAULT_THEMES_FALLBACK));
            if (foundThemes.isEmpty()) {
                foundThemes.addAll((Collection<ConfiguredThemeEditorStyle>)readOnlyLibThemes);
                foundThemes.addAll((Collection<ConfiguredThemeEditorStyle>)readOnlyFrameworkThemes);
            }
        }
        TreeSet temporarySet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (ConfiguredThemeEditorStyle theme : foundThemes) {
            temporarySet.add(theme.getQualifiedName());
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)temporarySet);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultThemeNames"));
        }
        return immutableList;
    }

    public static int getMinApiLevel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getMinApiLevel"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return 1;
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        return moduleInfo.getMinSdkVersion().getApiLevel();
    }

    @Nullable
    public static URL getCustomWidgetsJarUrl() {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        StringBuilder notFoundPaths = new StringBuilder();
        for (String path : CUSTOM_WIDGETS_JAR_PATHS) {
            String jarPath = homePath + path;
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)jarPath));
            if (root != null) {
                File rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                if (!rootFile.exists()) continue;
                try {
                    LOG.debug("Theme editor custom widgets found at " + jarPath);
                    return rootFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    LOG.error((Throwable)e);
                    continue;
                }
            }
            notFoundPaths.append(jarPath).append('\n');
        }
        LOG.error("Unable to find theme-editor-widgets.jar in paths:\n" + notFoundPaths.toString());
        return null;
    }

    public static boolean createNewStyle(final @NotNull Project project, final @NotNull VirtualFile resourceDir, final @NotNull String newStyleName, final @Nullable String parentStyleName, final @NotNull String fileName, final @NotNull List<String> folderNames) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "createNewStyle"));
        }
        if (resourceDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceDir", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "createNewStyle"));
        }
        if (newStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStyleName", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "createNewStyle"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "createNewStyle"));
        }
        if (folderNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderNames", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "createNewStyle"));
        }
        return (Boolean)new WriteCommandAction<Boolean>(project, "Create new style " + newStyleName, new PsiFile[0]){

            protected void run(@NotNull Result<Boolean> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/editors/theme/ThemeEditorUtils$3", "run"));
                }
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                result.setResult((Object)AndroidResourceUtil.createValueResource(project, resourceDir, newStyleName, null, ResourceType.STYLE, fileName, folderNames, new Processor<ResourceElement>(){

                    public boolean process(ResourceElement element) {
                        assert (element instanceof Style);
                        Style style = (Style)element;
                        if (parentStyleName != null) {
                            style.getParentStyle().setStringValue(parentStyleName);
                        }
                        return true;
                    }
                }));
            }
        }.execute().getResultObject();
    }

    @Nullable
    public static String showCreateNewStyleDialog(@Nullable ConfiguredThemeEditorStyle defaultParentStyle, @NotNull ThemeEditorContext themeEditorContext, boolean isTheme, boolean enableParentChoice, @Nullable String message, @Nullable ThemeSelectionPanel.ThemeChangedListener themeChangedListener) {
        boolean createStyle;
        if (themeEditorContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeEditorContext", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "showCreateNewStyleDialog"));
        }
        String defaultParentStyleName = null;
        if (isTheme && defaultParentStyle == null) {
            ImmutableList<String> defaultThemes = ThemeEditorUtils.getDefaultThemeNames(themeEditorContext.getThemeResolver());
            defaultParentStyleName = !defaultThemes.isEmpty() ? (String)defaultThemes.get(0) : null;
        } else if (defaultParentStyle != null) {
            defaultParentStyleName = defaultParentStyle.getQualifiedName();
        }
        NewStyleDialog dialog = new NewStyleDialog(isTheme, themeEditorContext, defaultParentStyleName, defaultParentStyle == null ? null : defaultParentStyle.getName(), message);
        dialog.enableParentChoice(enableParentChoice);
        if (themeChangedListener != null) {
            dialog.setThemeChangedListener(themeChangedListener);
        }
        if (!(createStyle = dialog.showAndGet())) {
            return null;
        }
        int minModuleApi = ThemeEditorUtils.getMinApiLevel(themeEditorContext.getCurrentContextModule());
        int minAcceptableApi = ResolutionUtils.getOriginalApiLevel(ResolutionUtils.getStyleResourceUrl(dialog.getStyleParentName()), themeEditorContext.getProject());
        String fileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STYLE);
        FolderConfiguration config = new FolderConfiguration();
        if (minModuleApi < minAcceptableApi) {
            VersionQualifier qualifier = new VersionQualifier(minAcceptableApi);
            config.setVersionQualifier(qualifier);
        }
        if (fileName == null) {
            LOG.error("Couldn't find a default filename for ResourceType.STYLE");
            return null;
        }
        List<String> dirNames = Collections.singletonList(config.getFolderName(ResourceFolderType.VALUES));
        String parentStyleName = dialog.getStyleParentName();
        Module module = themeEditorContext.getCurrentContextModule();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            LOG.error("Create new style for non-Android module " + module.getName());
            return null;
        }
        Project project = module.getProject();
        VirtualFile resourceDir = facet.getPrimaryResourceDir();
        if (resourceDir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", module.getName()));
            return null;
        }
        boolean isCreated = ThemeEditorUtils.createNewStyle(project, resourceDir, dialog.getStyleName(), parentStyleName, fileName, dirNames);
        return isCreated ? dialog.getStyleName() : null;
    }

    public static boolean isSelectedAppCompatTheme(@NotNull ThemeEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "isSelectedAppCompatTheme"));
        }
        ConfiguredThemeEditorStyle currentTheme = context.getCurrentTheme();
        return currentTheme != null && ThemeEditorUtils.isAppCompatTheme(currentTheme);
    }

    public static boolean isAppCompatTheme(@NotNull ConfiguredThemeEditorStyle configuredThemeEditorStyle) {
        if (configuredThemeEditorStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuredThemeEditorStyle", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "isAppCompatTheme"));
        }
        ConfiguredThemeEditorStyle currentTheme = configuredThemeEditorStyle;
        for (int i = 0; i < 50 && currentTheme != null; currentTheme = currentTheme.getParent(), ++i) {
            if (!currentTheme.getName().startsWith("Theme.AppCompat") || currentTheme.getSourceModule() != null) continue;
            return true;
        }
        return false;
    }

    public static void copyTheme(int apiLevel, @NotNull XmlTag toBeCopied) {
        if (toBeCopied == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toBeCopied", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "copyTheme"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiFile file = toBeCopied.getContainingFile();
        assert (file instanceof XmlFile) : file;
        ResourceFolderType folderType = ResourceHelper.getFolderType(file);
        assert (folderType != null) : file;
        FolderConfiguration config = ResourceHelper.getFolderConfiguration(file);
        assert (config != null) : file;
        VersionQualifier qualifier = new VersionQualifier(apiLevel);
        config.setVersionQualifier(qualifier);
        String folder = config.getFolderName(folderType);
        if (folderType != ResourceFolderType.VALUES) {
            OverrideResourceAction.forkResourceFile((XmlFile)file, folder, false);
        } else {
            XmlTag tag = OverrideResourceAction.getValueTag((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)toBeCopied, XmlTag.class, (boolean)false));
            if (tag != null) {
                PsiDirectory dir = null;
                PsiDirectory resFolder = file.getParent();
                if (resFolder != null) {
                    resFolder = resFolder.getParent();
                }
                if (resFolder != null && (dir = resFolder.findSubdirectory(folder)) == null) {
                    dir = resFolder.createSubdirectory(folder);
                }
                OverrideResourceAction.forkResourceValue(toBeCopied.getProject(), tag, file, dir, false);
            }
        }
    }

    public static int getVersionFromConfiguration(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getVersionFromConfiguration"));
        }
        VersionQualifier qualifier = configuration.getVersionQualifier();
        return qualifier != null ? qualifier.getVersion() : -1;
    }

    public static int getMinFolderApi(@NotNull List<String> folderNames, @NotNull Module module) {
        if (folderNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderNames", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getMinFolderApi"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getMinFolderApi"));
        }
        int minFolderApi = Integer.MAX_VALUE;
        int minModuleApi = ThemeEditorUtils.getMinApiLevel(module);
        for (String folderName : folderNames) {
            FolderConfiguration folderConfig = FolderConfiguration.getConfigForFolder((String)folderName);
            if (folderConfig == null) continue;
            VersionQualifier version = folderConfig.getVersionQualifier();
            int folderApi = version != null ? version.getVersion() : minModuleApi;
            minFolderApi = Math.min(minFolderApi, folderApi);
        }
        return minFolderApi;
    }

    @NotNull
    public static Configuration getConfigurationForModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getConfigurationForModule"));
        }
        Project project = module.getProject();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null) : "moduleComboModel must contain only Android modules";
        ConfigurationManager configurationManager = facet.getConfigurationManager();
        VirtualFile projectFile = project.getProjectFile();
        assert (projectFile != null);
        Configuration configuration = configurationManager.getConfiguration(projectFile);
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getConfigurationForModule"));
        }
        return configuration;
    }

    @NotNull
    public static List<ResourceFolderRepository> getResourceFolderRepositoriesFromSourceSet(@NotNull AndroidFacet facet, @Nullable SourceProvider provider) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getResourceFolderRepositoriesFromSourceSet"));
        }
        if (provider == null) {
            List<ResourceFolderRepository> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getResourceFolderRepositoriesFromSourceSet"));
            }
            return list;
        }
        Collection resDirectories = provider.getResDirectories();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        ArrayList folders = Lists.newArrayListWithExpectedSize((int)resDirectories.size());
        for (File dir : resDirectories) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(dir);
            if (virtualFile == null) continue;
            folders.add(ResourceFolderRegistry.get(facet, virtualFile));
        }
        ArrayList arrayList = folders;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getResourceFolderRepositoriesFromSourceSet"));
        }
        return arrayList;
    }

    public static JBColor getGoodContrastPreviewBackground(@NotNull ConfiguredThemeEditorStyle theme, @NotNull ResourceResolver resourceResolver) {
        float backgroundDistance;
        String colorBackgroundValue;
        Color colorBackground;
        if (theme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theme", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getGoodContrastPreviewBackground"));
        }
        if (resourceResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceResolver", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getGoodContrastPreviewBackground"));
        }
        ItemResourceValue themeColorBackgroundItem = ThemeEditorUtils.resolveItemFromParents(theme, "colorBackground", true);
        ResourceValue backgroundResourceValue = resourceResolver.resolveResValue((ResourceValue)themeColorBackgroundItem);
        if (backgroundResourceValue != null && (colorBackground = ResourceHelper.parseColor(colorBackgroundValue = backgroundResourceValue.getValue())) != null && (backgroundDistance = MaterialColorUtils.colorDistance(colorBackground, (Color)ThemeEditorComponent.PREVIEW_BACKGROUND)) < 8.5f && backgroundDistance < MaterialColorUtils.colorDistance(colorBackground, (Color)ThemeEditorComponent.ALT_PREVIEW_BACKGROUND)) {
            return ThemeEditorComponent.ALT_PREVIEW_BACKGROUND;
        }
        return ThemeEditorComponent.PREVIEW_BACKGROUND;
    }

    public static void acceptResourceResolverVisitor(@NotNull AndroidFacet mainFacet, @NotNull ResourceFolderVisitor visitor) {
        if (mainFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainFacet", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "acceptResourceResolverVisitor"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "acceptResourceResolverVisitor"));
        }
        List dependencies = Lists.reverse(AndroidUtils.getAllAndroidDependencies(mainFacet.getModule(), true));
        for (AndroidFacet dependency : Iterables.concat((Iterable)dependencies, (Iterable)ImmutableList.of((Object)((Object)mainFacet)))) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(dependency);
            if (androidModel == null) {
                SourceProvider provider = dependency.getMainSourceProvider();
                for (LocalResourceRepository localResourceRepository : ThemeEditorUtils.getResourceFolderRepositoriesFromSourceSet(dependency, provider)) {
                    visitor.visitResourceFolder(localResourceRepository, dependency.getName(), provider.getName(), true);
                }
                continue;
            }
            List<SourceProvider> activeProviders = androidModel.getActiveSourceProviders();
            for (SourceProvider sourceProvider : activeProviders) {
                for (LocalResourceRepository localResourceRepository : ThemeEditorUtils.getResourceFolderRepositoriesFromSourceSet(dependency, sourceProvider)) {
                    visitor.visitResourceFolder(localResourceRepository, dependency.getName(), sourceProvider.getName(), true);
                }
            }
            ImmutableSet selectedProviders = ImmutableSet.copyOf(activeProviders);
            for (SourceProvider provider : androidModel.getAllSourceProviders()) {
                if (selectedProviders.contains((Object)provider)) continue;
                for (LocalResourceRepository localResourceRepository : ThemeEditorUtils.getResourceFolderRepositoriesFromSourceSet(dependency, provider)) {
                    visitor.visitResourceFolder(localResourceRepository, dependency.getName(), provider.getName(), false);
                }
            }
        }
    }

    @NotNull
    public static ImmutableList<String> getModuleThemeQualifiedNamesList(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getModuleThemeQualifiedNamesList"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        ConfigurationManager manager = facet.getConfigurationManager();
        final ResourceResolverCache resolverCache = new ResourceResolverCache(manager);
        final IAndroidTarget target = manager.getTarget();
        final HashMap cache = new HashMap();
        final TreeSet themeNamesSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        ResourceFolderVisitor visitor = new ResourceFolderVisitor(){

            @Override
            public void visitResourceFolder(@NotNull LocalResourceRepository resources, String moduleName, @NotNull String variantName, boolean isSelected) {
                if (resources == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/editors/theme/ThemeEditorUtils$4", "visitResourceFolder"));
                }
                if (variantName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/editors/theme/ThemeEditorUtils$4", "visitResourceFolder"));
                }
                if (!isSelected) {
                    return;
                }
                block0: for (String simpleThemeName : resources.getItemsOfType(ResourceType.STYLE)) {
                    String themeStyleResourceUrl = "@style/" + simpleThemeName;
                    List themeItems = resources.getResourceItem(ResourceType.STYLE, simpleThemeName);
                    assert (themeItems != null);
                    for (ResourceItem themeItem : themeItems) {
                        ResourceResolver resolver = resolverCache.getResourceResolver(target, themeStyleResourceUrl, themeItem.getConfiguration());
                        ResourceValue themeItemResourceValue = themeItem.getResourceValue(false);
                        assert (themeItemResourceValue != null);
                        if (!resolver.isTheme(themeItemResourceValue, cache)) continue;
                        themeNamesSet.add(simpleThemeName);
                        continue block0;
                    }
                }
            }
        };
        ThemeEditorUtils.acceptResourceResolverVisitor(facet, visitor);
        ImmutableList immutableList = ImmutableList.copyOf((Collection)themeNamesSet);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getModuleThemeQualifiedNamesList"));
        }
        return immutableList;
    }

    @NotNull
    public static ChooseResourceDialog getResourceDialog(@NotNull EditedStyleItem item, @NotNull ThemeEditorContext context, EnumSet<ResourceType> allowedTypes) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getResourceDialog"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getResourceDialog"));
        }
        Module module = context.getModuleForResources();
        ItemResourceValue itemSelectedValue = item.getSelectedValue();
        String value = itemSelectedValue.getValue();
        boolean isFrameworkValue = itemSelectedValue.isFramework();
        String nameSuggestion = value;
        ResourceUrl url = ResourceUrl.parse((String)value, (boolean)isFrameworkValue);
        if (url != null) {
            nameSuggestion = url.name;
        }
        nameSuggestion = ThemeEditorUtils.getDefaultResourceName(context, nameSuggestion);
        ChooseResourceDialog.ResourceNameVisibility resourceNameVisibility = ChooseResourceDialog.ResourceNameVisibility.FORCE;
        if (nameSuggestion.startsWith("#")) {
            nameSuggestion = null;
            resourceNameVisibility = ChooseResourceDialog.ResourceNameVisibility.SHOW;
        }
        ChooseResourceDialog dialog = ChooseResourceDialog.builder().setModule(module).setTypes(allowedTypes).setCurrentValue(value).setIsFrameworkValue(isFrameworkValue).setResourceNameVisibility(resourceNameVisibility).setResourceNameSuggestion(nameSuggestion).build();
        dialog.setUseGlobalUndo(true);
        ChooseResourceDialog chooseResourceDialog = dialog;
        if (chooseResourceDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getResourceDialog"));
        }
        return chooseResourceDialog;
    }

    @NotNull
    private static String getDefaultResourceName(@NotNull ThemeEditorContext context, @NotNull String initialName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultResourceName"));
        }
        if (initialName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialName", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultResourceName"));
        }
        if (context.getCurrentTheme() == null || !context.getCurrentTheme().isReadOnly()) {
            String string = initialName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultResourceName"));
            }
            return string;
        }
        ResourceResolver resolver = context.getResourceResolver();
        assert (resolver != null);
        ResourceValue value = resolver.findResValue("@color/" + initialName, false);
        if (value == null) {
            String string = initialName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultResourceName"));
            }
            return string;
        }
        for (int i = 1; i <= 50; ++i) {
            String name = initialName + "_" + i;
            if (resolver.findResValue("@color/" + name, false) != null) continue;
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultResourceName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultResourceName"));
        }
        return "";
    }

    @NotNull
    public static String simplifyThemeName(@NotNull ConfiguredThemeEditorStyle theme) {
        if (theme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theme", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "simplifyThemeName"));
        }
        String name = theme.getQualifiedName();
        String[] pieces = name.split("\\.");
        String result = pieces.length > 1 && !"Light".equals(pieces[1]) ? pieces[1] : "Theme";
        for (ConfiguredThemeEditorStyle parent = theme; parent != null; parent = parent.getParent()) {
            if (!"Theme.Light".equals(parent.getName())) continue;
            String string = result + " Light";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "simplifyThemeName"));
            }
            return string;
        }
        String string = result + " Dark";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "simplifyThemeName"));
        }
        return string;
    }

    @NotNull
    public static String generateWordEnumeration(@NotNull Collection<String> words) {
        if (words == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateWordEnumeration"));
        }
        String string = AndroidTextUtils.generateCommaSeparatedList(words, "and");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateWordEnumeration"));
        }
        return string;
    }

    @NotNull
    public static Font scaleFontForAttribute(@NotNull Font font) {
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "scaleFontForAttribute"));
        }
        Font font2 = font.deriveFont((float)Math.ceil((float)font.getSize() * 0.9f));
        if (font2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "scaleFontForAttribute"));
        }
        return font2;
    }

    public static void setInheritsPopupMenuRecursive(JComponent comp) {
        comp.setInheritsPopupMenu(true);
        for (Component child : comp.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            ThemeEditorUtils.setInheritsPopupMenuRecursive((JComponent)child);
        }
    }

    public static interface ResourceFolderVisitor {
        public void visitResourceFolder(@NotNull LocalResourceRepository var1, String var2, @NotNull String var3, boolean var4);
    }
}

