/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryFilePaths {
    @NotNull
    public static LibraryFilePaths getInstance() {
        LibraryFilePaths libraryFilePaths = (LibraryFilePaths)ServiceManager.getService(LibraryFilePaths.class);
        if (libraryFilePaths == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/LibraryFilePaths", "getInstance"));
        }
        return libraryFilePaths;
    }

    @Nullable
    public File findSourceJarPath(@NotNull File libraryPath) {
        if (libraryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryPath", "com/android/tools/idea/gradle/LibraryFilePaths", "findSourceJarPath"));
        }
        return LibraryFilePaths.findArtifactFilePathInRepository(libraryPath, "-sources.jar", true);
    }

    @Nullable
    public File findPomPathForLibrary(@NotNull File libraryPath) {
        if (libraryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryPath", "com/android/tools/idea/gradle/LibraryFilePaths", "findPomPathForLibrary"));
        }
        return LibraryFilePaths.findArtifactFilePathInRepository(libraryPath, ".pom", false);
    }

    @Nullable
    private static File findArtifactFilePathInRepository(@NotNull File libraryPath, @NotNull String fileNameSuffix, boolean searchInIdeCache) {
        File librarySourceDirPath;
        File sourceJarPath;
        if (libraryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryPath", "com/android/tools/idea/gradle/LibraryFilePaths", "findArtifactFilePathInRepository"));
        }
        if (fileNameSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameSuffix", "com/android/tools/idea/gradle/LibraryFilePaths", "findArtifactFilePathInRepository"));
        }
        if (!libraryPath.isFile()) {
            return null;
        }
        File parentPath = libraryPath.getParentFile();
        String name = FileUtil.getNameWithoutExtension((File)libraryPath);
        String sourceFileName = name + fileNameSuffix;
        if (parentPath != null) {
            File sourceJar = LibraryFilePaths.findChildPath(parentPath, sourceFileName);
            if (sourceJar != null) {
                return sourceJar;
            }
            if ((parentPath = parentPath.getParentFile()) != null) {
                for (File child : FileUtil.notNullize((File[])parentPath.listFiles())) {
                    if (!child.isDirectory() || (sourceJar = LibraryFilePaths.findChildPath(child, sourceFileName)) == null) continue;
                    return sourceJar;
                }
            }
        }
        if (searchInIdeCache && (sourceJarPath = new File(librarySourceDirPath = InternetAttachSourceProvider.getLibrarySourceDir(), sourceFileName)).isFile()) {
            return sourceJarPath;
        }
        return null;
    }

    @Nullable
    private static File findChildPath(@NotNull File parentPath, @NotNull String childName) {
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPath", "com/android/tools/idea/gradle/LibraryFilePaths", "findChildPath"));
        }
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "com/android/tools/idea/gradle/LibraryFilePaths", "findChildPath"));
        }
        for (File child : FileUtil.notNullize((File[])parentPath.listFiles())) {
            if (!childName.equals(child.getName())) continue;
            return child.isFile() ? child : null;
        }
        return null;
    }
}

