/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependencyModel
extends DependencyModel {
    private static final Logger LOG = Logger.getInstance(ModuleDependencyModel.class);
    @NonNls
    private static final String PROJECT = "project";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String CONFIGURATION = "configuration";
    @NotNull
    private String myConfigurationName;
    @NotNull
    private GradleDslMethodCall myDslElement;
    @NotNull
    private GradleDslExpression myPath;
    @Nullable
    private GradleDslExpression myConfiguration;

    @NotNull
    static List<ModuleDependencyModel> create(@NotNull String configurationName, @NotNull GradleDslMethodCall methodCall) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "create"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "create"));
        }
        ArrayList result = Lists.newArrayList();
        if (PROJECT.equals(methodCall.getName())) {
            for (GradleDslElement argument : methodCall.getArguments()) {
                if (argument instanceof GradleDslExpression) {
                    result.add(new ModuleDependencyModel(configurationName, methodCall, (GradleDslExpression)argument, null));
                    continue;
                }
                if (!(argument instanceof GradleDslExpressionMap)) continue;
                GradleDslExpressionMap dslMap = (GradleDslExpressionMap)argument;
                GradleDslExpression pathElement = dslMap.getPropertyElement(PATH, GradleDslExpression.class);
                if (pathElement == null) {
                    assert (methodCall.getPsiElement() != null);
                    String msg = String.format("'%1$s' is not a valid module dependency", methodCall.getPsiElement().getText());
                    LOG.warn(msg);
                    continue;
                }
                GradleDslExpression configuration = dslMap.getPropertyElement(CONFIGURATION, GradleDslExpression.class);
                result.add(new ModuleDependencyModel(configurationName, methodCall, pathElement, configuration));
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "create"));
        }
        return arrayList;
    }

    static void createAndAddToList(@NotNull GradleDslElementList list, @NotNull String configurationName, @NotNull String path, @Nullable String config) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "createAndAddToList"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "createAndAddToList"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PATH, "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "createAndAddToList"));
        }
        String methodName = PROJECT;
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)list, methodName, configurationName);
        GradleDslExpressionMap mapArguments = new GradleDslExpressionMap(methodCall, methodName);
        mapArguments.setNewLiteral(PATH, path);
        if (config != null) {
            mapArguments.setNewLiteral(CONFIGURATION, config);
        }
        methodCall.addNewArgument(mapArguments);
        list.addNewElement(methodCall);
    }

    private ModuleDependencyModel(@NotNull String configurationName, @NotNull GradleDslMethodCall dslElement, @NotNull GradleDslExpression path, @Nullable GradleDslExpression configuration) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "<init>"));
        }
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PATH, "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "<init>"));
        }
        this.myConfigurationName = configurationName;
        this.myDslElement = dslElement;
        this.myPath = path;
        this.myConfiguration = configuration;
    }

    @Override
    @NotNull
    protected GradleDslMethodCall getDslElement() {
        GradleDslMethodCall gradleDslMethodCall = this.myDslElement;
        if (gradleDslMethodCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "getDslElement"));
        }
        return gradleDslMethodCall;
    }

    @Override
    @NotNull
    public String configurationName() {
        String string = this.myConfigurationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "configurationName"));
        }
        return string;
    }

    @NotNull
    public String name() {
        List<String> pathSegments = GradleUtil.getPathSegments(this.path().value());
        int segmentCount = pathSegments.size();
        String string = segmentCount > 0 ? pathSegments.get(segmentCount - 1) : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "name"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        String newPath;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "setName"));
        }
        List segments = Splitter.on((String)":").splitToList((CharSequence)this.path().value());
        ArrayList modifiableSegments = Lists.newArrayList((Iterable)segments);
        int segmentCount = modifiableSegments.size();
        if (segmentCount == 0) {
            newPath = ":" + name.trim();
        } else {
            modifiableSegments.set(segmentCount - 1, name);
            newPath = Joiner.on((String)":").join((Iterable)modifiableSegments);
        }
        this.setPath(newPath);
    }

    @NotNull
    public GradleNotNullValue<String> path() {
        String path = this.myPath.getValue(String.class);
        assert (path != null);
        GradleNotNullValue<String> gradleNotNullValue = new GradleNotNullValue<String>(this.myPath, path);
        if (gradleNotNullValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", PATH));
        }
        return gradleNotNullValue;
    }

    public void setPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PATH, "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "setPath"));
        }
        this.myPath.setValue(path);
    }

    @NotNull
    public GradleNullableValue<String> configuration() {
        if (this.myConfiguration == null) {
            GradleNullableValue<Object> gradleNullableValue = new GradleNullableValue<Object>(this.myDslElement, null);
            if (gradleNullableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", CONFIGURATION));
            }
            return gradleNullableValue;
        }
        GradleNullableValue<String> gradleNullableValue = new GradleNullableValue<String>(this.myConfiguration, this.myConfiguration.getValue(String.class));
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", CONFIGURATION));
        }
        return gradleNullableValue;
    }

    void setConfiguration(@NotNull String configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", CONFIGURATION, "com/android/tools/idea/gradle/dsl/model/dependencies/ModuleDependencyModel", "setConfiguration"));
        }
        if (this.myConfiguration != null) {
            this.myConfiguration.setValue(configuration);
            return;
        }
        GradleDslElement parent = this.myPath.getParent();
        if (parent instanceof GradleDslExpressionMap) {
            ((GradleDslExpressionMap)parent).setNewLiteral(CONFIGURATION, configuration);
        } else {
            String path = this.path().value();
            if (this.myPath instanceof GradleDslLiteral) {
                GradleDslExpressionMap newMapArgument = new GradleDslExpressionMap(this.myDslElement, PROJECT);
                newMapArgument.setNewLiteral(PATH, path);
                newMapArgument.setNewLiteral(CONFIGURATION, configuration);
                this.myDslElement.remove(this.myPath);
                this.myDslElement.addNewArgument(newMapArgument);
            }
        }
    }

    void removeConfiguration() {
        GradleDslElement parent;
        if (this.myConfiguration != null && (parent = this.myConfiguration.getParent()) instanceof GradleDslExpressionMap) {
            ((GradleDslExpressionMap)parent).removeProperty(CONFIGURATION);
            this.myConfiguration = null;
        }
    }
}

