/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.repositories;

import com.android.tools.idea.gradle.dsl.model.repositories.MavenCredentialsModel;
import com.android.tools.idea.gradle.dsl.model.repositories.UrlBasedRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenCredentialsDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenRepositoryModel
extends UrlBasedRepositoryModel {
    @NonNls
    private static final String ARTIFACT_URLS = "artifactUrls";

    public MavenRepositoryModel(@NotNull MavenRepositoryDslElement dslElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/repositories/MavenRepositoryModel", "<init>"));
        }
        this(dslElement, "maven", "https://repo1.maven.org/maven2/");
    }

    protected MavenRepositoryModel(@NotNull MavenRepositoryDslElement dslElement, @NotNull String defaultRepoName, @NotNull String defaultRepoUrl) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/repositories/MavenRepositoryModel", "<init>"));
        }
        if (defaultRepoName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultRepoName", "com/android/tools/idea/gradle/dsl/model/repositories/MavenRepositoryModel", "<init>"));
        }
        if (defaultRepoUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultRepoUrl", "com/android/tools/idea/gradle/dsl/model/repositories/MavenRepositoryModel", "<init>"));
        }
        super(dslElement, defaultRepoName, defaultRepoUrl);
    }

    @NotNull
    public List<GradleNotNullValue<String>> artifactUrls() {
        assert (this.myDslElement != null);
        ImmutableList artifactUrls = this.myDslElement.getListProperty(ARTIFACT_URLS, String.class);
        ImmutableList immutableList = artifactUrls != null ? artifactUrls : ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/repositories/MavenRepositoryModel", ARTIFACT_URLS));
        }
        return immutableList;
    }

    @Nullable
    public MavenCredentialsModel credentials() {
        assert (this.myDslElement != null);
        MavenCredentialsDslElement credentials = this.myDslElement.getPropertyElement("credentials", MavenCredentialsDslElement.class);
        return credentials != null ? new MavenCredentialsModel(credentials) : null;
    }
}

