/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.model.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.GradleResolvedVariable;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public abstract class GradleDslExpression
extends GradleDslElement {
    @NotNull
    private List<GradleResolvedVariable> myResolvedVariables;
    @Nullable
    protected GrExpression myExpression;

    protected GradleDslExpression(@Nullable GradleDslElement parent, @Nullable GroovyPsiElement psiElement, @NotNull String name, @Nullable GrExpression expression) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "<init>"));
        }
        super(parent, psiElement, name);
        this.myResolvedVariables = ImmutableList.of();
        this.myExpression = expression;
    }

    @Nullable
    public GrExpression getExpression() {
        return this.myExpression;
    }

    @Nullable
    public abstract Object getValue();

    @Nullable
    public abstract <T> T getValue(@NotNull Class<T> var1);

    public abstract void setValue(@NotNull Object var1);

    @Override
    @NotNull
    public List<GradleResolvedVariable> getResolvedVariables() {
        List<GradleResolvedVariable> list = this.myResolvedVariables;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "getResolvedVariables"));
        }
        return list;
    }

    public void setResolvedVariables(@NotNull List<GradleResolvedVariable> resolvedVariables) {
        if (resolvedVariables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedVariables", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "setResolvedVariables"));
        }
        this.myResolvedVariables = ImmutableList.copyOf(resolvedVariables);
    }

    @Nullable
    protected <T> T resolveReference(@NotNull String referenceText, @NotNull Class<T> clazz) {
        GradleDslElement resolvedElement;
        GradleDslFile dslFile;
        int index;
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "resolveReference"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "resolveReference"));
        }
        GradleDslElement searchStartElement = this;
        String searchReferenceText = referenceText;
        List referenceTextSegments = Splitter.on((char)'.').trimResults().omitEmptyStrings().splitToList((CharSequence)referenceText);
        int segmentCount = referenceTextSegments.size();
        for (index = 0; index < segmentCount && (dslFile = GradleDslExpression.resolveProjectReference(searchStartElement, (String)referenceTextSegments.get(index))) != null; ++index) {
            searchStartElement = dslFile;
        }
        if (index >= segmentCount) {
            resolvedElement = searchStartElement;
        } else {
            searchReferenceText = Joiner.on((char)'.').join(referenceTextSegments.subList(index, segmentCount));
            resolvedElement = GradleDslExpression.resolveReferenceInSameModule(searchStartElement, searchReferenceText);
        }
        GradleDslFile dslFile2 = searchStartElement.getDslFile();
        if (resolvedElement == null) {
            resolvedElement = GradleDslExpression.resolveReferenceInParentModules(dslFile2, searchReferenceText);
        }
        if (resolvedElement != null) {
            T result = null;
            if (clazz.isInstance(resolvedElement)) {
                result = clazz.cast(resolvedElement);
            } else if (resolvedElement instanceof GradleDslExpression) {
                result = ((GradleDslExpression)resolvedElement).getValue(clazz);
            }
            if (result != null) {
                this.setResolvedVariables((List<GradleResolvedVariable>)ImmutableList.of((Object)new GradleResolvedVariable(referenceText, result, resolvedElement)));
                return result;
            }
        }
        if (clazz.isAssignableFrom(String.class)) {
            if ("rootDir".equals(searchReferenceText)) {
                return clazz.cast(Projects.getBaseDirPath(dslFile2.getProject()).getPath());
            }
            if ("projectDir".equals(searchReferenceText)) {
                return clazz.cast(dslFile2.getDirectoryPath().getPath());
            }
            return clazz.cast(referenceText);
        }
        return null;
    }

    @Nullable
    private static GradleDslFile resolveProjectReference(GradleDslElement startElement, @NotNull String projectReference) {
        GradleDslFile dslFile;
        if (projectReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectReference", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "resolveProjectReference"));
        }
        if ("project".equals(projectReference)) {
            return dslFile;
        }
        if ("parent".equals(projectReference)) {
            return dslFile.getParentModuleDslFile();
        }
        if ("rootProject".equals(projectReference)) {
            for (dslFile = startElement.getDslFile(); dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir())); dslFile = dslFile.getParentModuleDslFile()) {
            }
            return dslFile;
        }
        String standardProjectKey = ProjectPropertiesDslElement.getStandardProjectKey(projectReference);
        if (standardProjectKey != null) {
            String modulePath = standardProjectKey.substring(standardProjectKey.indexOf("'") + 1, standardProjectKey.lastIndexOf("'"));
            GradleSettingsModel model = GradleSettingsModel.get(dslFile.getProject());
            if (model == null) {
                return null;
            }
            File moduleDirectory = model.moduleDirectory(modulePath);
            if (moduleDirectory == null) {
                return null;
            }
            while (dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir()))) {
                dslFile = dslFile.getParentModuleDslFile();
            }
            if (dslFile == null) {
                return null;
            }
            return GradleDslExpression.findDslFile(dslFile, moduleDirectory);
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInSameModule(GradleDslElement startElement, @NotNull String referenceText) {
        GradleDslFile parentModuleDslFile;
        GradleDslFile dslFile;
        GradleDslElement propertyElement;
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "resolveReferenceInSameModule"));
        }
        for (GradleDslElement element = startElement; element != null; element = element.getParent()) {
            GradleDslElement extPropertyElement;
            if (!(element instanceof GradlePropertiesDslElement)) continue;
            GradleDslElement propertyElement2 = ((GradlePropertiesDslElement)element).getPropertyElement(referenceText);
            if (propertyElement2 != null) {
                return propertyElement2;
            }
            if (!(element instanceof GradleDslFile)) continue;
            ExtDslElement extDslElement = ((GradleDslFile)element).getPropertyElement("ext", ExtDslElement.class);
            if (extDslElement == null || (extPropertyElement = extDslElement.getPropertyElement(referenceText)) == null) break;
            return extPropertyElement;
        }
        if ((propertyElement = GradleDslExpression.resolveReferenceInPropertiesFile(dslFile = startElement.getDslFile(), referenceText)) != null) {
            return propertyElement;
        }
        if (dslFile.getParentModuleDslFile() == null) {
            return null;
        }
        GradleDslFile rootProjectDslFile = dslFile;
        while ((parentModuleDslFile = rootProjectDslFile.getParentModuleDslFile()) != null) {
            rootProjectDslFile = parentModuleDslFile;
        }
        return GradleDslExpression.resolveReferenceInPropertiesFile(rootProjectDslFile, referenceText);
    }

    @Nullable
    private static GradleDslElement resolveReferenceInParentModules(@NotNull GradleDslFile dslFile, @NotNull String referenceText) {
        if (dslFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslFile", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "resolveReferenceInParentModules"));
        }
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "resolveReferenceInParentModules"));
        }
        for (GradleDslFile parentDslFile = dslFile.getParentModuleDslFile(); parentDslFile != null; parentDslFile = parentDslFile.getParentModuleDslFile()) {
            GradleDslElement extPropertyElement;
            ExtDslElement extDslElement = parentDslFile.getPropertyElement("ext", ExtDslElement.class);
            if (extDslElement != null && (extPropertyElement = extDslElement.getPropertyElement(referenceText)) != null) {
                return extPropertyElement;
            }
            if (parentDslFile.getParentModuleDslFile() == null) {
                return null;
            }
            GradleDslElement propertyElement = GradleDslExpression.resolveReferenceInPropertiesFile(parentDslFile, referenceText);
            if (propertyElement == null) continue;
            return propertyElement;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInPropertiesFile(@NotNull GradleDslFile buildDslFile, @NotNull String referenceText) {
        if (buildDslFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDslFile", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "resolveReferenceInPropertiesFile"));
        }
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "resolveReferenceInPropertiesFile"));
        }
        GradleDslFile propertiesDslFile = buildDslFile.getSiblingDslFile();
        return propertiesDslFile != null ? propertiesDslFile.getPropertyElement(referenceText) : null;
    }

    @Nullable
    private static GradleDslFile findDslFile(GradleDslFile rootModuleDslFile, File moduleDirectory) {
        if (FileUtil.filesEqual((File)rootModuleDslFile.getDirectoryPath(), (File)moduleDirectory)) {
            return rootModuleDslFile;
        }
        for (GradleDslFile dslFile : rootModuleDslFile.getChildModuleDslFiles()) {
            if (FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)moduleDirectory)) {
                return dslFile;
            }
            GradleDslFile childDslFile = GradleDslExpression.findDslFile(dslFile, moduleDirectory);
            if (childDslFile == null) continue;
            return dslFile;
        }
        return null;
    }
}

