/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectFolder {
    public abstract void createTopLevelBuildFile() throws IOException;

    public abstract void createIdeaProjectFolder() throws IOException;

    @VisibleForTesting
    static class ProjectFolderImpl
    extends ProjectFolder {
        @NotNull
        private final File myPath;

        ProjectFolderImpl(@NotNull File path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/project/importing/ProjectFolder$ProjectFolderImpl", "<init>"));
            }
            this.myPath = path;
        }

        @Override
        public void createTopLevelBuildFile() throws IOException {
            File buildFile = GradleUtil.getGradleBuildFilePath(this.myPath);
            if (buildFile.isFile()) {
                return;
            }
            FileUtilRt.createIfNotExists((File)buildFile);
            String contents = "// Top-level build file where you can add configuration options common to all sub-projects/modules." + SystemProperties.getLineSeparator();
            FileUtil.writeToFile((File)buildFile, (String)contents);
        }

        @Override
        public void createIdeaProjectFolder() throws IOException {
            File ideaFolderPath = new File(this.myPath, ".idea");
            if (ideaFolderPath.isDirectory()) {
                boolean librariesFolderDeleted;
                File librariesFolderPath = new File(ideaFolderPath, "libraries");
                if (librariesFolderPath.exists() && !(librariesFolderDeleted = FileUtil.delete((File)librariesFolderPath))) {
                    this.getLogger().info(String.format("Failed to delete %1$s'", librariesFolderPath.getPath()));
                }
                return;
            }
            FileUtil.ensureExists((File)ideaFolderPath);
        }

        @NotNull
        private Logger getLogger() {
            Logger logger = Logger.getInstance(this.getClass());
            if (logger == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/importing/ProjectFolder$ProjectFolderImpl", "getLogger"));
            }
            return logger;
        }
    }

    public static class Factory {
        @NotNull
        ProjectFolder create(@NotNull File projectFolderPath) {
            if (projectFolderPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFolderPath", "com/android/tools/idea/gradle/project/importing/ProjectFolder$Factory", "create"));
            }
            ProjectFolderImpl projectFolderImpl = new ProjectFolderImpl(projectFolderPath);
            if (projectFolderImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/importing/ProjectFolder$Factory", "create"));
            }
            return projectFolderImpl;
        }
    }
}

