/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;

public class JavaModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String myModuleName;
    @NotNull
    private Collection<JavaModuleContentRoot> myContentRoots;
    @NotNull
    private Collection<JavaModuleDependency> myJavaModuleDependencies;
    @NotNull
    private Collection<JarLibraryDependency> myJarLibraryDependencies;
    @NotNull
    private Map<String, Set<File>> myArtifactsByConfiguration;
    @NotNull
    private List<String> myConfigurations;
    @Nullable
    private ExtIdeaCompilerOutput myCompilerOutput;
    @Nullable
    private File myBuildFolderPath;
    @Nullable
    private String myLanguageLevel;
    private boolean myBuildable;
    private boolean myAndroidModuleWithoutVariants;

    public JavaModuleModel(@NotNull IdeaModule ideaModule, @Nullable ModuleExtendedModel javaModel, boolean androidModuleWithoutVariants) {
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "<init>"));
        }
        this(ideaModule.getName(), JavaModuleModel.getContentRoots(ideaModule, javaModel), JavaModuleModel.getDependencies(ideaModule), JavaModuleModel.getArtifactsByConfiguration(javaModel), JavaModuleModel.getCompilerOutput(javaModel), ideaModule.getGradleProject().getBuildDirectory(), JavaModuleModel.getLanguageLevel(javaModel), !androidModuleWithoutVariants && JavaModuleModel.isBuildable(ideaModule), androidModuleWithoutVariants);
    }

    @Nullable
    private static ExtIdeaCompilerOutput getCompilerOutput(@Nullable ModuleExtendedModel javaModel) {
        return javaModel != null ? javaModel.getCompilerOutput() : null;
    }

    @NotNull
    private static Collection<? extends IdeaContentRoot> getContentRoots(@NotNull IdeaModule ideaModule, @Nullable ModuleExtendedModel javaModel) {
        DomainObjectSet contentRoots;
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "getContentRoots"));
        }
        DomainObjectSet domainObjectSet = contentRoots = javaModel != null ? javaModel.getContentRoots() : null;
        if (contentRoots == null) {
            contentRoots = ideaModule.getContentRoots();
        }
        Object object = contentRoots != null ? contentRoots : Collections.emptyList();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "getContentRoots"));
        }
        return object;
    }

    @NotNull
    private static Map<String, Set<File>> getArtifactsByConfiguration(@Nullable ModuleExtendedModel javaModel) {
        Map artifactsByConfiguration = Collections.emptyMap();
        if (javaModel != null) {
            artifactsByConfiguration = javaModel.getArtifactsByConfiguration();
        }
        Map map = artifactsByConfiguration;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "getArtifactsByConfiguration"));
        }
        return map;
    }

    @NotNull
    private static List<? extends IdeaDependency> getDependencies(@NotNull IdeaModule ideaModule) {
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "getDependencies"));
        }
        List dependencies = ideaModule.getDependencies().getAll();
        if (dependencies != null) {
            List list = dependencies;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "getDependencies"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "getDependencies"));
        }
        return list;
    }

    private static boolean isBuildable(@NotNull IdeaModule ideaModule) {
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "isBuildable"));
        }
        for (GradleTask task : ideaModule.getGradleProject().getTasks()) {
            if (!"compileJava".equals(task.getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getLanguageLevel(@Nullable ModuleExtendedModel javaModel) {
        return javaModel != null ? javaModel.getJavaSourceCompatibility() : null;
    }

    public JavaModuleModel(@NotNull String name, @NotNull Collection<? extends IdeaContentRoot> contentRoots, @NotNull List<? extends IdeaDependency> dependencies, @Nullable Map<String, Set<File>> artifactsByConfiguration, @Nullable ExtIdeaCompilerOutput compilerOutput, @Nullable File buildFolderPath, @Nullable String languageLevel, boolean buildable, boolean androidModuleWithoutVariants) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "<init>"));
        }
        if (contentRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoots", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "<init>"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "<init>"));
        }
        this.myContentRoots = new ArrayList<JavaModuleContentRoot>();
        this.myJavaModuleDependencies = new ArrayList<JavaModuleDependency>();
        this.myJarLibraryDependencies = new ArrayList<JarLibraryDependency>();
        this.myModuleName = name;
        for (IdeaContentRoot ideaContentRoot : contentRoots) {
            if (ideaContentRoot == null) continue;
            this.myContentRoots.add(JavaModuleContentRoot.copy(ideaContentRoot));
        }
        for (IdeaDependency ideaDependency : dependencies) {
            JavaModuleDependency moduleDependency;
            if (ideaDependency instanceof IdeaSingleEntryLibraryDependency) {
                JarLibraryDependency libraryDependency = JarLibraryDependency.copy((IdeaSingleEntryLibraryDependency)ideaDependency);
                if (libraryDependency == null) continue;
                this.myJarLibraryDependencies.add(libraryDependency);
                continue;
            }
            if (!(ideaDependency instanceof IdeaModuleDependency) || (moduleDependency = JavaModuleDependency.copy((IdeaModuleDependency)ideaDependency)) == null) continue;
            this.myJavaModuleDependencies.add(moduleDependency);
        }
        this.myArtifactsByConfiguration = artifactsByConfiguration != null ? artifactsByConfiguration : Collections.emptyMap();
        this.myConfigurations = new ArrayList<String>(this.myArtifactsByConfiguration.keySet());
        Collections.sort(this.myConfigurations);
        this.myCompilerOutput = compilerOutput;
        this.myBuildFolderPath = buildFolderPath;
        this.myLanguageLevel = languageLevel;
        this.myBuildable = buildable;
        this.myAndroidModuleWithoutVariants = androidModuleWithoutVariants;
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public Collection<JavaModuleContentRoot> getContentRoots() {
        Collection<JavaModuleContentRoot> collection = this.myContentRoots;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "getContentRoots"));
        }
        return collection;
    }

    public boolean containsSourceFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "containsSourceFile"));
        }
        for (JavaModuleContentRoot contentRoot : this.getContentRoots()) {
            if (contentRoot == null || !JavaModuleModel.containsFile(contentRoot, file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFile(@NotNull JavaModuleContentRoot contentRoot, @NotNull File file) {
        if (contentRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "containsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "containsFile"));
        }
        return JavaModuleModel.containsFile(contentRoot.getSourceDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getTestDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getResourceDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getGenSourceDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getGenTestDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getTestResourceDirPaths(), file);
    }

    private static boolean containsFile(@NotNull Collection<File> folderPaths, @NotNull File file) {
        if (folderPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPaths", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "containsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "containsFile"));
        }
        for (File path : folderPaths) {
            if (!FileUtil.isAncestor((File)path, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Map<String, Set<File>> getArtifactsByConfiguration() {
        Map<String, Set<File>> map = this.myArtifactsByConfiguration;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "getArtifactsByConfiguration"));
        }
        return map;
    }

    @Nullable
    public ExtIdeaCompilerOutput getCompilerOutput() {
        return this.myCompilerOutput;
    }

    @Nullable
    public File getBuildFolderPath() {
        return this.myBuildFolderPath;
    }

    @NotNull
    public Collection<JavaModuleDependency> getJavaModuleDependencies() {
        Collection<JavaModuleDependency> collection = this.myJavaModuleDependencies;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "getJavaModuleDependencies"));
        }
        return collection;
    }

    @NotNull
    public Collection<JarLibraryDependency> getJarLibraryDependencies() {
        Collection<JarLibraryDependency> collection = this.myJarLibraryDependencies;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "getJarLibraryDependencies"));
        }
        return collection;
    }

    public boolean isBuildable() {
        return this.myBuildable;
    }

    public boolean isAndroidModuleWithoutVariants() {
        return this.myAndroidModuleWithoutVariants;
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        if (this.myLanguageLevel != null) {
            return LanguageLevel.parse((String)this.myLanguageLevel);
        }
        return null;
    }

    @NotNull
    public List<String> getConfigurations() {
        List<String> list = this.myConfigurations;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/JavaModuleModel", "getConfigurations"));
        }
        return list;
    }
}

