/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class GradleSyncSummary {
    @NotNull
    private final Project myProject;
    private GradleVersion myGradleVersion;
    private long mySyncTimestamp;
    private boolean mySyncErrorsFound;
    private boolean myWrongJdkFound;

    public GradleSyncSummary(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncSummary", "<init>"));
        }
        this.myProject = project;
        this.reset();
    }

    public GradleVersion getGradleVersion() {
        return this.myGradleVersion;
    }

    public void setGradleVersion(@NotNull GradleVersion gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/project/sync/GradleSyncSummary", "setGradleVersion"));
        }
        this.myGradleVersion = gradleVersion;
    }

    public long getSyncTimestamp() {
        return this.mySyncTimestamp;
    }

    public void setSyncTimestamp(long syncTimestamp) {
        this.mySyncTimestamp = syncTimestamp;
    }

    public void setSyncErrorsFound(boolean syncErrorsFound) {
        this.mySyncErrorsFound = syncErrorsFound;
    }

    public void setWrongJdkFound(boolean wrongJdkFound) {
        this.myWrongJdkFound = wrongJdkFound;
    }

    public boolean hasSyncErrors() {
        if (this.mySyncErrorsFound || this.myWrongJdkFound) {
            return true;
        }
        SyncMessages messages = SyncMessages.getInstance(this.myProject);
        return messages.getErrorCount() > 0;
    }

    void reset() {
        this.myGradleVersion = null;
        this.mySyncTimestamp = -1L;
        this.mySyncErrorsFound = false;
        this.myWrongJdkFound = false;
    }
}

