/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class MissingAndroidSupportRepoErrorHandler
extends BaseSyncErrorHandler {
    private static final String INSTALL_ANDROID_SUPPORT_REPO = "Please install the Android Support Repository from the Android SDK Manager.";

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull NotificationData notification, @NotNull Project project) {
        if (rootCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCause", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSupportRepoErrorHandler", "findErrorMessage"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSupportRepoErrorHandler", "findErrorMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSupportRepoErrorHandler", "findErrorMessage"));
        }
        String text = rootCause.getMessage();
        if (rootCause instanceof RuntimeException && StringUtil.isNotEmpty((String)text) && text.contains("Could not find") && text.contains("com.android.support:")) {
            MissingAndroidSupportRepoErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.MISSING_ANDROID_SUPPORT_REPO);
            text = text + "\n\nPlease install the Android Support Repository from the Android SDK Manager.";
            return text;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSupportRepoErrorHandler", "getQuickFixHyperlinks"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSupportRepoErrorHandler", "getQuickFixHyperlinks"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSupportRepoErrorHandler", "getQuickFixHyperlinks"));
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        if (!facets.isEmpty()) {
            hyperlinks.add(new OpenAndroidSdkManagerHyperlink());
        }
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/MissingAndroidSupportRepoErrorHandler", "getQuickFixHyperlinks"));
        }
        return arrayList;
    }
}

