/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class CustomNotificationListener
extends NotificationListener.Adapter {
    @NotNull
    private final Project myProject;
    @NotNull
    private final NotificationHyperlink[] myHyperlinks;

    public CustomNotificationListener(@NotNull Project project, NotificationHyperlink ... hyperlinks) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/CustomNotificationListener", "<init>"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/android/tools/idea/gradle/project/sync/hyperlink/CustomNotificationListener", "<init>"));
        }
        this.myProject = project;
        this.myHyperlinks = hyperlinks;
    }

    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/hyperlink/CustomNotificationListener", "hyperlinkActivated"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/project/sync/hyperlink/CustomNotificationListener", "hyperlinkActivated"));
        }
        for (NotificationHyperlink hyperlink : this.myHyperlinks) {
            if (!hyperlink.executeIfClicked(this.myProject, e)) continue;
            if (hyperlink.isCloseOnClick() || this.myHyperlinks.length == 1) {
                notification.expire();
            }
            return;
        }
    }

    @NotNull
    public NotificationHyperlink[] getHyperlinks() {
        if (this.myHyperlinks == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/hyperlink/CustomNotificationListener", "getHyperlinks"));
        }
        return this.myHyperlinks;
    }
}

