/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class FixBuildToolsVersionHyperlink
extends NotificationHyperlink {
    @NotNull
    private final VirtualFile myBuildFile;
    @NotNull
    private final String myVersion;

    public FixBuildToolsVersionHyperlink(@NotNull VirtualFile buildFile, @NotNull String version) {
        if (buildFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildFile", "com/android/tools/idea/gradle/project/sync/hyperlink/FixBuildToolsVersionHyperlink", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/project/sync/hyperlink/FixBuildToolsVersionHyperlink", "<init>"));
        }
        super("fix.build.tools.version", "Update Build Tools version and sync project");
        this.myBuildFile = buildFile;
        this.myVersion = version;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/FixBuildToolsVersionHyperlink", "execute"));
        }
        FixBuildToolsVersionHyperlink.setBuildToolsVersion(project, this.myBuildFile, this.myVersion, true);
    }

    static void setBuildToolsVersion(@NotNull Project project, @NotNull VirtualFile buildFile, @NotNull String version, boolean requestSync) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/FixBuildToolsVersionHyperlink", "setBuildToolsVersion"));
        }
        if (buildFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildFile", "com/android/tools/idea/gradle/project/sync/hyperlink/FixBuildToolsVersionHyperlink", "setBuildToolsVersion"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/project/sync/hyperlink/FixBuildToolsVersionHyperlink", "setBuildToolsVersion"));
        }
        GradleBuildModel buildModel = GradleBuildModel.parseBuildFile(buildFile, project);
        AndroidModel android = buildModel.android();
        if (android == null) {
            return;
        }
        if (version.equals(android.buildToolsVersion())) {
            return;
        }
        android.setBuildToolsVersion(version);
        WriteCommandAction.runWriteCommandAction((Project)project, buildModel::applyChanges);
        if (requestSync) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
        }
    }
}

