/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InstallCMakeHyperlink
extends NotificationHyperlink {
    public InstallCMakeHyperlink() {
        super("install.cmake", "Install CMake and sync project");
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallCMakeHyperlink", "execute"));
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)progressIndicator);
        StudioProgressRunner progressRunner = new StudioProgressRunner(false, false, "Loading Remote SDK", true, project);
        RepoManager.RepoLoadedCallback onComplete = packages -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallCMakeHyperlink", "lambda$execute$0"));
            }
            Collection cmakePackages = packages.getRemotePackagesForPrefix("cmake");
            if (!cmakePackages.isEmpty()) {
                RemotePackage cmakePackage = cmakePackages.size() == 1 ? (RemotePackage)ContainerUtil.getFirstItem((Collection)cmakePackages) : sdkHandler.getLatestRemotePackageForPrefix("cmake", false, (ProgressIndicator)progressIndicator);
                if (cmakePackage != null) {
                    ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, (Collection<String>)ImmutableList.of((Object)cmakePackage.getPath()));
                    if (dialog != null && dialog.showAndGet()) {
                        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
                    }
                    return;
                }
                InstallCMakeHyperlink.notifyCMakePackageNotFound(project);
            }
        };
        Runnable onError = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallCMakeHyperlink", "lambda$execute$1"));
            }
            InstallCMakeHyperlink.notifyCMakePackageNotFound(project);
        };
        sdkManager.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)progressRunner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    private static void notifyCMakePackageNotFound(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallCMakeHyperlink", "notifyCMakePackageNotFound"));
        }
        Messages.showErrorDialog((Project)project, (String)"Failed to obtain CMake package", (String)"Gradle Sync");
    }
}

