/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class ToggleOfflineModeHyperlink
extends NotificationHyperlink {
    private final boolean myEnableOfflineMode;

    @Nullable
    public static ToggleOfflineModeHyperlink enableOfflineMode(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/ToggleOfflineModeHyperlink", "enableOfflineMode"));
        }
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        return settings.isOfflineWork() ? null : new ToggleOfflineModeHyperlink(true);
    }

    @Nullable
    public static ToggleOfflineModeHyperlink disableOfflineMode(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/ToggleOfflineModeHyperlink", "disableOfflineMode"));
        }
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        return !settings.isOfflineWork() ? null : new ToggleOfflineModeHyperlink(false);
    }

    private ToggleOfflineModeHyperlink(boolean enableOfflineMode) {
        super("toggle.offline.mode", ToggleOfflineModeHyperlink.getText(enableOfflineMode));
        this.myEnableOfflineMode = enableOfflineMode;
    }

    @NotNull
    private static String getText(boolean enableOfflineMode) {
        String msg = enableOfflineMode ? "Enable" : "Disable";
        String string = msg + " Gradle 'offline mode' and sync project";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/hyperlink/ToggleOfflineModeHyperlink", "getText"));
        }
        return string;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/ToggleOfflineModeHyperlink", "execute"));
        }
        GradleSettings.getInstance((Project)project).setOfflineWork(this.myEnableOfflineMode);
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
    }

    public boolean isEnableOfflineMode() {
        return this.myEnableOfflineMode;
    }
}

