/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.base.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GradleModelVersionCheck {
    static final GradleVersion MINIMUM_SUPPORTED_VERSION = GradleVersion.parse((String)"1.0.0");

    static boolean isSupportedVersion(@NotNull AndroidProject androidProject) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/sync/idea/GradleModelVersionCheck", "isSupportedVersion"));
        }
        return GradleModelVersionCheck.isSupportedVersion(androidProject, MINIMUM_SUPPORTED_VERSION);
    }

    static boolean isSupportedVersion(@NotNull AndroidProject androidProject, @NotNull GradleVersion minimumSupportedVersion) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/sync/idea/GradleModelVersionCheck", "isSupportedVersion"));
        }
        if (minimumSupportedVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimumSupportedVersion", "com/android/tools/idea/gradle/project/sync/idea/GradleModelVersionCheck", "isSupportedVersion"));
        }
        GradleVersion version = GradleModelVersionCheck.getModelVersion(androidProject);
        if (version != null) {
            return version.compareTo(minimumSupportedVersion) >= 0;
        }
        return false;
    }

    @Nullable
    static GradleVersion getModelVersion(@NotNull AndroidProject androidProject) {
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/sync/idea/GradleModelVersionCheck", "getModelVersion"));
        }
        String modelVersion = androidProject.getModelVersion();
        if (Strings.isNullOrEmpty((String)modelVersion)) {
            return null;
        }
        int snapshotIndex = modelVersion.indexOf("-");
        if (snapshotIndex != -1) {
            modelVersion = modelVersion.substring(0, snapshotIndex);
        }
        return GradleVersion.tryParse((String)modelVersion);
    }

    private GradleModelVersionCheck() {
    }
}

