/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.common.VariantSelector;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.GradleModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.JavaModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.NdkModuleSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;

public class ModuleSetup {
    @NotNull
    private final IdeModifiableModelsProvider myIdeModelsProvider;
    @NotNull
    private final VariantSelector myVariantSelector;
    @NotNull
    private final GradleModuleSetup myGradleModuleSetup;
    @NotNull
    private final AndroidModuleSetup myAndroidModuleSetup;
    @NotNull
    private final NdkModuleSetup myNdkModuleSetup;
    @NotNull
    private final JavaModuleSetup myJavaModuleSetup;

    public ModuleSetup(@NotNull IdeModifiableModelsProvider ideModelsProvider) {
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "<init>"));
        }
        this(ideModelsProvider, new VariantSelector(), new GradleModuleSetup(), new AndroidModuleSetup(), new NdkModuleSetup(), new JavaModuleSetup());
    }

    @VisibleForTesting
    ModuleSetup(@NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull VariantSelector variantSelector, @NotNull GradleModuleSetup gradleModuleSetup, @NotNull AndroidModuleSetup androidModuleSetup, @NotNull NdkModuleSetup ndkModuleSetup, @NotNull JavaModuleSetup javaModuleSetup) {
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "<init>"));
        }
        if (variantSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantSelector", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "<init>"));
        }
        if (gradleModuleSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModuleSetup", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "<init>"));
        }
        if (androidModuleSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModuleSetup", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "<init>"));
        }
        if (ndkModuleSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ndkModuleSetup", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "<init>"));
        }
        if (javaModuleSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModuleSetup", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "<init>"));
        }
        this.myIdeModelsProvider = ideModelsProvider;
        this.myVariantSelector = variantSelector;
        this.myGradleModuleSetup = gradleModuleSetup;
        this.myAndroidModuleSetup = androidModuleSetup;
        this.myNdkModuleSetup = ndkModuleSetup;
        this.myJavaModuleSetup = javaModuleSetup;
    }

    public void setUpModule(@NotNull Module module, @NotNull SyncAction.ModuleModels models, @NotNull ProgressIndicator indicator) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "setUpModule"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "setUpModule"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "setUpModule"));
        }
        boolean isProjectRootFolder = false;
        File gradleSettingsFile = new File(ModuleSetup.getModulePath(module), "settings.gradle");
        if (gradleSettingsFile.isFile() && !models.hasModel(AndroidProject.class) && !models.hasModel(NativeAndroidProject.class)) {
            isProjectRootFolder = true;
        }
        this.myGradleModuleSetup.setUpModule(module, this.myIdeModelsProvider, models);
        AndroidProject androidProject = models.findModel(AndroidProject.class);
        if (androidProject != null) {
            AndroidModuleModel androidModel = this.createAndroidModel(module, androidProject);
            if (androidModel != null) {
                this.myAndroidModuleSetup.setUpModule(module, this.myIdeModelsProvider, androidModel, models, indicator);
            } else {
                this.removeAndroidFacetFrom(module);
                this.setUpJavaModule(module, models, indicator, true);
            }
            return;
        }
        this.removeAndroidFacetFrom(module);
        NativeAndroidProject nativeAndroidProject = models.findModel(NativeAndroidProject.class);
        if (nativeAndroidProject != null) {
            NdkModuleModel ndkModuleModel = new NdkModuleModel(module.getName(), ModuleSetup.getModulePath(module), nativeAndroidProject);
            this.myNdkModuleSetup.setUpModule(module, this.myIdeModelsProvider, ndkModuleModel, models, indicator);
            return;
        }
        Facets.removeAllFacets(this.myIdeModelsProvider.getModifiableFacetModel(module), NdkFacet.getFacetTypeId());
        if (!isProjectRootFolder) {
            this.setUpJavaModule(module, models, indicator, false);
        }
    }

    private void removeAndroidFacetFrom(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "removeAndroidFacetFrom"));
        }
        Facets.removeAllFacets(this.myIdeModelsProvider.getModifiableFacetModel(module), AndroidFacet.ID);
    }

    @Nullable
    private AndroidModuleModel createAndroidModel(@NotNull Module module, @NotNull AndroidProject androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "createAndroidModel"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "createAndroidModel"));
        }
        Variant variantToSelect = this.myVariantSelector.findVariantToSelect(androidProject);
        if (variantToSelect != null) {
            return new AndroidModuleModel(module.getName(), ModuleSetup.getModulePath(module), androidProject, variantToSelect.getName());
        }
        return null;
    }

    @NotNull
    private static File getModulePath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "getModulePath"));
        }
        File moduleFilePath = new File(FileUtil.toSystemDependentName((String)module.getModuleFilePath()));
        File file = moduleFilePath.getParentFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "getModulePath"));
        }
        return file;
    }

    private void setUpJavaModule(@NotNull Module module, @NotNull SyncAction.ModuleModels models, @NotNull ProgressIndicator indicator, boolean androidProjectWithoutVariants) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "setUpJavaModule"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "setUpJavaModule"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleSetup", "setUpJavaModule"));
        }
        ModuleExtendedModel javaModel = models.findModel(ModuleExtendedModel.class);
        JavaModuleModel javaModuleModel = new JavaModuleModel(models.getModule(), javaModel, androidProjectWithoutVariants);
        this.myJavaModuleSetup.setUpModule(module, this.myIdeModelsProvider, javaModuleModel, models, indicator);
    }
}

