/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.tools.idea.gradle.util.FilePaths;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncLibraryRegistry
implements Disposable {
    @VisibleForTesting
    static final Key<SyncLibraryRegistry> KEY = Key.create((String)"com.android.tools.gradle.sync.ProjectLibraryRegistry");
    private static Factory ourFactory = new Factory();
    @Nullable
    private Project myProject;
    @NotNull
    private final Map<String, Library> myProjectLibrariesByName;
    @NotNull
    private final Set<LibraryToUpdate> myLibrariesToUpdate;

    public static void replaceForTesting(@NotNull Project project, @Nullable SyncLibraryRegistry libraryRegistry) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry", "replaceForTesting"));
        }
        project.putUserData(KEY, (Object)libraryRegistry);
    }

    @NotNull
    public static SyncLibraryRegistry getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry", "getInstance"));
        }
        SyncLibraryRegistry registry = (SyncLibraryRegistry)project.getUserData(KEY);
        if (registry == null || registry.isDisposed()) {
            registry = ourFactory.createNewInstance(project);
            project.putUserData(KEY, (Object)registry);
        }
        SyncLibraryRegistry syncLibraryRegistry = registry;
        if (syncLibraryRegistry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry", "getInstance"));
        }
        return syncLibraryRegistry;
    }

    SyncLibraryRegistry(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry", "<init>"));
        }
        this.myProjectLibrariesByName = new HashMap<String, Library>();
        this.myLibrariesToUpdate = new HashSet<LibraryToUpdate>();
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
        this.registerExistingLibraries();
    }

    private void registerExistingLibraries() {
        LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)this.myProject);
        for (Library library : libraryTable.getLibraries()) {
            String name = library.getName();
            if (name == null) continue;
            this.myProjectLibrariesByName.put(name, library);
        }
    }

    public void markAsUsed(@NotNull Library library, File ... newBinaryPaths) {
        Library used;
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry", "markAsUsed"));
        }
        if (newBinaryPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBinaryPaths", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry", "markAsUsed"));
        }
        this.checkNotDisposed();
        String name = library.getName();
        if (name != null && (used = this.myProjectLibrariesByName.remove(name)) != null) {
            ArrayList existingBinaryUrls = Lists.newArrayList((Object[])used.getUrls(OrderRootType.CLASSES));
            boolean urlCountChanged = newBinaryPaths.length != existingBinaryUrls.size();
            ArrayList<String> newBinaryUrls = new ArrayList<String>();
            for (File newBinaryPath : newBinaryPaths) {
                String newBinaryUrl = FilePaths.pathToIdeaUrl(newBinaryPath);
                existingBinaryUrls.remove(newBinaryUrl);
                newBinaryUrls.add(newBinaryUrl);
            }
            if (!existingBinaryUrls.isEmpty() || urlCountChanged) {
                LibraryToUpdate libraryToUpdate = new LibraryToUpdate(used, newBinaryUrls);
                this.myLibrariesToUpdate.add(libraryToUpdate);
            }
        }
    }

    @NotNull
    public Collection<Library> getLibrariesToRemove() {
        this.checkNotDisposed();
        Collection<Library> collection = this.myProjectLibrariesByName.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry", "getLibrariesToRemove"));
        }
        return collection;
    }

    @NotNull
    public List<LibraryToUpdate> getLibrariesToUpdate() {
        this.checkNotDisposed();
        ImmutableList immutableList = ImmutableList.copyOf(this.myLibrariesToUpdate);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry", "getLibrariesToUpdate"));
        }
        return immutableList;
    }

    private void checkNotDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Already disposed");
        }
    }

    @VisibleForTesting
    boolean isDisposed() {
        return Disposer.isDisposed((Disposable)this);
    }

    public void dispose() {
        assert (this.myProject != null);
        this.myProject.putUserData(KEY, null);
        this.myProject = null;
        this.myProjectLibrariesByName.clear();
        this.myLibrariesToUpdate.clear();
    }

    @NotNull
    Map<String, Library> getProjectLibrariesByName() {
        Map<String, Library> map = this.myProjectLibrariesByName;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry", "getProjectLibrariesByName"));
        }
        return map;
    }

    public static void restoreFactory() {
        SyncLibraryRegistry.setFactory(new Factory());
    }

    public static void setFactory(@NotNull Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry", "setFactory"));
        }
        ourFactory = factory;
    }

    public static class LibraryToUpdate {
        @NotNull
        private final Library myLibrary;
        @NotNull
        private final Collection<String> myNewBinaryUrls;

        @VisibleForTesting
        public LibraryToUpdate(@NotNull Library library, @NotNull Collection<String> newBinaryUrls) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry$LibraryToUpdate", "<init>"));
            }
            if (newBinaryUrls == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBinaryUrls", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry$LibraryToUpdate", "<init>"));
            }
            this.myLibrary = library;
            this.myNewBinaryUrls = newBinaryUrls;
        }

        @NotNull
        public Library getLibrary() {
            Library library = this.myLibrary;
            if (library == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry$LibraryToUpdate", "getLibrary"));
            }
            return library;
        }

        @NotNull
        public Collection<String> getNewBinaryUrls() {
            Collection<String> collection = this.myNewBinaryUrls;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry$LibraryToUpdate", "getNewBinaryUrls"));
            }
            return collection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LibraryToUpdate update = (LibraryToUpdate)o;
            return Objects.equals(this.myLibrary.getName(), update.myLibrary.getName()) && Objects.equals(this.myNewBinaryUrls, update.myNewBinaryUrls);
        }

        public int hashCode() {
            return Objects.hash(this.myLibrary.getName(), this.myNewBinaryUrls);
        }
    }

    @VisibleForTesting
    public static class Factory {
        @NotNull
        public SyncLibraryRegistry createNewInstance(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry$Factory", "createNewInstance"));
            }
            SyncLibraryRegistry syncLibraryRegistry = new SyncLibraryRegistry(project);
            if (syncLibraryRegistry == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/SyncLibraryRegistry$Factory", "createNewInstance"));
            }
            return syncLibraryRegistry;
        }
    }
}

