/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.java;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.JavaModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupErrors;
import com.android.tools.idea.gradle.project.sync.setup.module.java.JavaModuleDependenciesSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModuleSetupStep
extends JavaModuleSetupStep {
    private static final DependencyScope DEFAULT_DEPENDENCY_SCOPE = DependencyScope.COMPILE;
    @NotNull
    private final JavaModuleDependenciesSetup myDependenciesSetup;

    public DependenciesModuleSetupStep() {
        this(new JavaModuleDependenciesSetup());
    }

    @VisibleForTesting
    DependenciesModuleSetupStep(@NotNull JavaModuleDependenciesSetup dependenciesSetup) {
        if (dependenciesSetup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesSetup", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "<init>"));
        }
        this.myDependenciesSetup = dependenciesSetup;
    }

    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull JavaModuleModel javaModuleModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "doSetUpModule"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "doSetUpModule"));
        }
        if (javaModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModuleModel", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "doSetUpModule"));
        }
        ArrayList<String> unresolved = new ArrayList<String>();
        for (JavaModuleDependency javaModuleDependency : javaModuleModel.getJavaModuleDependencies()) {
            DependenciesModuleSetupStep.updateDependency(module, ideModelsProvider, javaModuleDependency);
        }
        for (JarLibraryDependency jarLibraryDependency : javaModuleModel.getJarLibraryDependencies()) {
            if (jarLibraryDependency.isResolved()) {
                this.updateDependency(module, ideModelsProvider, jarLibraryDependency);
                continue;
            }
            unresolved.add(jarLibraryDependency.getName());
        }
        UnresolvedDependenciesReporter.getInstance().report(unresolved, module);
    }

    private static void updateDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull JavaModuleDependency dependency) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "updateDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "updateDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "updateDependency"));
        }
        DependencySetupErrors setupErrors = DependencySetupErrors.getInstance(module.getProject());
        String moduleName = dependency.getModuleName();
        Module found = null;
        for (Module m : modelsProvider.getModules()) {
            if (!moduleName.equals(m.getName())) continue;
            found = m;
        }
        ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
        if (found != null) {
            AndroidFacet androidFacet = Facets.findFacet(found, modelsProvider, AndroidFacet.ID);
            if (androidFacet == null) {
                ModuleOrderEntry entry = moduleModel.addModuleOrderEntry(found);
                entry.setExported(true);
            } else {
                setupErrors.addInvalidModuleDependency(moduleModel.getModule(), found.getName(), "Java modules cannot depend on Android modules");
            }
            return;
        }
        setupErrors.addMissingModule(moduleName, module.getName(), null);
    }

    private void updateDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull JarLibraryDependency dependency) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "updateDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "updateDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "updateDependency"));
        }
        DependencyScope scope = DependenciesModuleSetupStep.parseScope(dependency.getScope());
        File binaryPath = dependency.getBinaryPath();
        if (binaryPath == null) {
            DependencySetupErrors setupErrors = DependencySetupErrors.getInstance(module.getProject());
            setupErrors.addMissingBinaryPath(module.getName());
            return;
        }
        String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)binaryPath.getPath());
        this.myDependenciesSetup.setUpLibraryDependency(module, modelsProvider, name, scope, binaryPath, dependency.getSourcePath(), dependency.getJavadocPath());
    }

    @NotNull
    private static DependencyScope parseScope(@Nullable String scope) {
        if (scope == null) {
            DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
            if (dependencyScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "parseScope"));
            }
            return dependencyScope;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scope.equalsIgnoreCase(dependencyScope.toString())) continue;
            DependencyScope dependencyScope2 = dependencyScope;
            if (dependencyScope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "parseScope"));
            }
            return dependencyScope2;
        }
        DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "parseScope"));
        }
        return dependencyScope;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Java dependencies setup" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep", "getDescription"));
        }
        return "Java dependencies setup";
    }
}

