/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.lint.AddTargetVersionCheckQuickFix;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Locale;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AddTargetApiQuickFix
implements AndroidLintQuickFix {
    private final boolean myRequiresApi;
    private int myApi;
    private PsiElement myElement;

    public AddTargetApiQuickFix(int api, boolean requiresApi, PsiElement element) {
        this.myApi = api;
        this.myRequiresApi = requiresApi;
        this.myElement = element;
    }

    private String getAnnotationValue(boolean fullyQualified) {
        return AddTargetVersionCheckQuickFix.getVersionField(this.myApi, fullyQualified);
    }

    @Override
    @NotNull
    public String getName() {
        String key = this.getAnnotationValue(false);
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiFile.class);
        if (file instanceof XmlFile) {
            if ("Suppress With tools:targetApi Attribute" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AddTargetApiQuickFix", "getName"));
            }
            return "Suppress With tools:targetApi Attribute";
        }
        if (this.myRequiresApi) {
            String string = AndroidBundle.message("android.lint.fix.add.requires.api", key);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AddTargetApiQuickFix", "getName"));
            }
            return string;
        }
        String string = AndroidBundle.message("android.lint.fix.add.target.api", key);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AddTargetApiQuickFix", "getName"));
        }
        return string;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AddTargetApiQuickFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AddTargetApiQuickFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/android/tools/idea/lint/AddTargetApiQuickFix", "isApplicable"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiModifierListOwner.class, (boolean)false) != null || PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false) != null;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AddTargetApiQuickFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AddTargetApiQuickFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lint/AddTargetApiQuickFix", "apply"));
        }
        PsiModifierListOwner container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)startElement, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (container == null) {
            XmlFile file;
            XmlTag element = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            if (element != null && (file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)element, XmlFile.class, (boolean)false)) != null) {
                AndroidResourceUtil.ensureNamespaceImported(file, "http://schemas.android.com/tools", null);
                String codeName = SdkVersionInfo.getBuildCode((int)this.myApi);
                codeName = codeName == null ? Integer.toString(this.myApi) : codeName.toLowerCase(Locale.US);
                element.setAttribute("targetApi", "http://schemas.android.com/tools", codeName);
            }
            return;
        }
        while (container != null && container instanceof PsiAnonymousClass) {
            container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)container, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        }
        if (container == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)container)) {
            return;
        }
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList != null) {
            Project project = startElement.getProject();
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            String fqcn = this.myRequiresApi ? "android.support.annotation.RequiresApi" : "android.annotation.TargetApi";
            String annotationText = this.myRequiresApi ? "@" + fqcn + "(api=" + this.getAnnotationValue(true) + ")" : "@" + fqcn + "(" + this.getAnnotationValue(true) + ")";
            PsiAnnotation newAnnotation = elementFactory.createAnnotationFromText(annotationText, (PsiElement)container);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)container, (String[])new String[]{"android.annotation.TargetApi"});
            if (annotation != null && annotation.isPhysical()) {
                annotation.replace((PsiElement)newAnnotation);
            } else {
                PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
                AddAnnotationFix fix = new AddAnnotationFix(fqcn, container, attributes, new String[0]);
                fix.invoke(project, null, container.getContainingFile());
            }
        }
    }
}

