/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.AppIndexingApiDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintGoogleAppIndexingApiWarningInspection
extends AndroidLintInspectionBase {
    public AndroidLintGoogleAppIndexingApiWarningInspection() {
        super(AndroidBundle.message("android.lint.inspections.google.app.indexing.api.warning", new Object[0]), AppIndexingApiDetector.ISSUE_APP_INDEXING_API);
    }

    @NotNull
    static AndroidLintQuickFix[] getAppIndexingQuickFix(PsiElement startElement, String message) {
        AppIndexingApiDetector.IssueType type = AppIndexingApiDetector.IssueType.parse((String)message);
        switch (type) {
            case SCHEME_MISSING: 
            case URL_MISSING: {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set scheme", "scheme", "http")};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintGoogleAppIndexingApiWarningInspection", "getAppIndexingQuickFix"));
                }
                return androidLintQuickFixArray;
            }
            case HOST_MISSING: {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set host", "host", null)};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintGoogleAppIndexingApiWarningInspection", "getAppIndexingQuickFix"));
                }
                return androidLintQuickFixArray;
            }
            case MISSING_SLASH: {
                XmlAttribute attr;
                String path;
                PsiElement parent = startElement.getParent();
                if (!(parent instanceof XmlAttribute) || (path = (attr = (XmlAttribute)parent).getValue()) == null) break;
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with /" + path, path, "/" + path)};
                if (androidLintQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintGoogleAppIndexingApiWarningInspection", "getAppIndexingQuickFix"));
                }
                return androidLintQuickFixArray;
            }
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintGoogleAppIndexingApiWarningInspection", "getAppIndexingQuickFix"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintGoogleAppIndexingApiWarningInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintGoogleAppIndexingApiWarningInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintGoogleAppIndexingApiWarningInspection", "getQuickFixes"));
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = AndroidLintGoogleAppIndexingApiWarningInspection.getAppIndexingQuickFix(startElement, message);
        if (androidLintQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintGoogleAppIndexingApiWarningInspection", "getQuickFixes"));
        }
        return androidLintQuickFixArray;
    }
}

